/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Type<T> {
    private final String name;
    private final String description;
    private final Class<T> type;
    public static final Type<String> STRING = new Type<String>("string", "a string value", String.class);
    public static final Type<Boolean> BOOLEAN = new Type<Boolean>("boolean", "a boolean value", Boolean.class);
    public static final Type<Integer> INTEGER = new Type<Integer>("integer", "an integer value", Integer.class);
    public static final Type<Long> LONG = new Type<Long>("long", "a long value", Long.class);
    public static final Type<Float> FLOAT = new Type<Float>("float", "a float value", Float.class);
    public static final Type<Double> DOUBLE = new Type<Double>("double", "a double value", Double.class);

    private Type(@Nonnull String name, @Nonnull String description, @Nonnull Class<T> type) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
        this.type = Objects.requireNonNull(type);
    }

    @Nonnull
    String name() {
        return this.name;
    }

    @Nonnull
    String description() {
        return this.description;
    }

    @Nonnull
    Class<T> type() {
        return this.type;
    }

    public String toString() {
        return "Type{name='" + this.name + "'}";
    }

    public static <T> Type<Collection<T>> listOf(Type<T> type) {
        if (Collection.class.isAssignableFrom(type.type())) {
            throw new IllegalArgumentException("nested list types is not supported.");
        }
        return new Type<Collection<T>>(String.format("list of %s", type.name()), String.format("a list of %s values", type.name()), Collection.class);
    }
}

