/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;

public class SecurityLogHelper {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final Log4jLogProvider logProvider;

    public SecurityLogHelper(FormattedLogFormat format) {
        this.logProvider = format == FormattedLogFormat.PLAIN ? new Log4jLogProvider(LogConfig.createBuilderToOutputStream((OutputStream)this.outContent, (Level)Level.INFO).withCategory(false).build()) : new Log4jLogProvider(LogConfig.createBuilderToOutputStream((OutputStream)this.outContent, (Level)Level.INFO).withJsonLayout("classpath:org/neo4j/logging/QueryLogJsonLayout.json").build());
    }

    public Log4jLogProvider getLogProvider() {
        return this.logProvider;
    }

    public void assertDoesNotContainsMessage(String message) {
        Assertions.assertThat((String)this.outContent.toString()).doesNotContain(new CharSequence[]{message});
    }

    public ContentValidator assertLog(FormattedLogFormat format) {
        String[] contentLines = this.outContent.toString().split(System.lineSeparator());
        return SecurityLogHelper.assertLog(format, contentLines);
    }

    public static ContentValidator assertLog(FormattedLogFormat format, String[] content) {
        switch (format) {
            case PLAIN: {
                return new LoggerContentValidator(content);
            }
            case JSON: {
                return new JsonContentValidator(content);
            }
        }
        throw new AssertionError();
    }

    public static LogLineContent line() {
        return new LogLineContent();
    }

    private static void assertMessage(LogLineContent expected, String message) {
        if (expected.expectedMessage != null) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedMessage, (Object)message, (String)"'message' mismatch");
        } else if (expected.messagePrefix != null) {
            ((AbstractStringAssert)Assertions.assertThat((String)message).describedAs("'message prefix' mismatch", new Object[0])).startsWith((CharSequence)expected.messagePrefix);
        } else {
            throw new IllegalStateException("Missing expected message or message prefix criteria");
        }
    }

    public static interface ContentValidator {
        public void containsOnly(LogLineContent ... var1);

        public void containsOrdered(LogLineContent ... var1);
    }

    private static class LoggerContentValidator
    implements ContentValidator {
        private final String[] contentLines;
        private static final Pattern LOGGER_LINE_PARSER = Pattern.compile("^(?<time>\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{4}) (?<level>\\w{4,5})\\s{1,2}((?<source>embedded-session\\t|bolt-session[^>]*>|server-session(?:\\t[^\\t]*){3})\\t)?(\\[(?<authenticatedUser>[^\\s:]+)(:(?<executingUser>[^\\s:]+))?]: )?(?<message>.+?)");

        private LoggerContentValidator(String[] contentLines) {
            this.contentLines = contentLines;
        }

        @Override
        public void containsOnly(LogLineContent ... logLines) {
            Assertions.assertThat((int)logLines.length).isEqualTo(this.contentLines.length);
            for (int i = 0; i < logLines.length; ++i) {
                this.assertLine(this.contentLines[i], logLines[i]);
            }
        }

        @Override
        public void containsOrdered(LogLineContent ... logLines) {
            Assertions.assertThat((int)this.contentLines.length).isGreaterThanOrEqualTo(logLines.length);
            int j = 0;
            for (LogLineContent expected : logLines) {
                boolean found = false;
                while (j < this.contentLines.length) {
                    if (this.equalLine(this.contentLines[j], expected)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)found, (String)String.format("Did not find line:  %s %nin %n%s", expected, Arrays.toString(this.contentLines)));
            }
        }

        private boolean equalLine(String contentLine, LogLineContent expected) {
            Matcher matcher = LOGGER_LINE_PARSER.matcher(contentLine);
            return !(!matcher.matches() || !Objects.equals(expected.expectedLevel, matcher.group("level")) || expected.expectedAuthenticatedUser != null && !Objects.equals(expected.expectedAuthenticatedUser, matcher.group("authenticatedUser")) || expected.expectedExecutingUser != null && !expected.expectedExecutingUser.equals(expected.expectedAuthenticatedUser) && !Objects.equals(expected.expectedExecutingUser, matcher.group("executingUser")) || !Objects.equals(expected.expectedMessage, matcher.group("message")));
        }

        private void assertLine(String contentLine, LogLineContent expected) {
            Matcher matcher = LOGGER_LINE_PARSER.matcher(contentLine);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)matcher.matches());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedLevel, (Object)matcher.group("level"), (String)"'level' mismatch");
            if (expected.expectedAuthenticatedUser != null) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedAuthenticatedUser, (Object)matcher.group("authenticatedUser"), (String)"'authenticatedUser' mismatch");
            }
            if (expected.expectedExecutingUser != null && !expected.expectedExecutingUser.equals(expected.expectedAuthenticatedUser)) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedExecutingUser, (Object)matcher.group("executingUser"), (String)"'executingUser' mismatch");
            }
            SecurityLogHelper.assertMessage(expected, matcher.group("message"));
        }
    }

    private static class JsonContentValidator
    implements ContentValidator {
        private final String[] contentLines;

        JsonContentValidator(String[] contentLines) {
            this.contentLines = contentLines;
        }

        @Override
        public void containsOnly(LogLineContent ... logLines) {
            try {
                Assertions.assertThat((int)this.contentLines.length).isEqualTo(logLines.length);
                for (int i = 0; i < logLines.length; ++i) {
                    LogLineContent expected = logLines[i];
                    ObjectMapper mapper = new ObjectMapper();
                    Map map = (Map)mapper.readValue(this.contentLines[i], (TypeReference)new TypeReference<Map<String, String>>(){});
                    this.assertLine(expected, map);
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void containsOrdered(LogLineContent ... logLines) {
            try {
                Assertions.assertThat((int)this.contentLines.length).isGreaterThanOrEqualTo(logLines.length);
                int j = 0;
                for (LogLineContent expected : logLines) {
                    boolean found = false;
                    while (j < this.contentLines.length) {
                        ObjectMapper mapper = new ObjectMapper();
                        Map map = (Map)mapper.readValue(this.contentLines[j], (TypeReference)new TypeReference<Map<String, String>>(){});
                        if (this.equalLine(expected, map)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)found, (String)String.format("Did not find line:  %s %nin %n%s", expected, Arrays.toString(this.contentLines)));
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean equalLine(LogLineContent expected, Map<String, String> map) {
            return Objects.equals("security", map.get("type")) && Objects.equals(expected.expectedLevel, map.get("level")) && Objects.equals(expected.expectedSource, map.get("source")) && Objects.equals(expected.expectedDatabase, map.get("database")) && Objects.equals(expected.expectedExecutingUser, map.get("executingUser")) && Objects.equals(expected.expectedAuthenticatedUser, map.get("authenticatedUser")) && Objects.equals(expected.expectedMessage, map.get("message"));
        }

        private void assertLine(LogLineContent expected, Map<String, String> map) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"security", (Object)map.get("type"), (String)"'type' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedLevel, (Object)map.get("level"), (String)"'level' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedSource, (Object)map.get("source"), (String)"'source' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedDatabase, (Object)map.get("database"), (String)"'database' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedExecutingUser, (Object)map.get("executingUser"), (String)"'executingUser' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedAuthenticatedUser, (Object)map.get("authenticatedUser"), (String)"'authenticatedUser' mismatch");
            SecurityLogHelper.assertMessage(expected, map.get("message"));
        }
    }

    public static class LogLineContent {
        private String expectedLevel;
        private String expectedSource;
        private String expectedDatabase;
        private String expectedExecutingUser;
        private String expectedAuthenticatedUser;
        private String expectedMessage;
        private String messagePrefix;

        public LogLineContent level(Level level) {
            this.expectedLevel = level.toString();
            return this;
        }

        public LogLineContent source(String source) {
            this.expectedSource = source;
            return this;
        }

        public LogLineContent database(String database) {
            this.expectedDatabase = database;
            return this;
        }

        public LogLineContent executingUser(String username) {
            this.expectedExecutingUser = username;
            return this;
        }

        public LogLineContent authenticatedUser(String username) {
            this.expectedAuthenticatedUser = username;
            return this;
        }

        public LogLineContent message(String message) {
            this.expectedMessage = message;
            return this;
        }

        public LogLineContent messagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public String toString() {
            return "LogLineContent{expectedLevel='" + this.expectedLevel + "', expectedSource='" + this.expectedSource + "', expectedDatabase='" + this.expectedDatabase + "', expectedExecutingUser='" + this.expectedExecutingUser + "', expectedAuthenticatedUser='" + this.expectedAuthenticatedUser + "', expectedMessage='" + this.expectedMessage + "', messagePrefix='" + this.messagePrefix + "'}";
        }
    }
}

