/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialReadPageCursor;
import org.neo4j.adversaries.pagecache.AdversarialWritePageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.monitoring.PageFileCounters;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.version.FileTruncateEvent;

public class AdversarialPagedFile
implements PagedFile {
    private final PagedFile delegate;
    private final Adversary adversary;

    public AdversarialPagedFile(PagedFile delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public PageCursor io(long pageId, int pf_flags, CursorContext context) throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        PageCursor pageCursor = this.delegate.io(pageId, pf_flags, context);
        if ((pf_flags & 1) == 1) {
            return new AdversarialReadPageCursor(pageCursor, this.adversary);
        }
        return new AdversarialWritePageCursor(pageCursor, this.adversary);
    }

    public int pageSize() {
        return this.delegate.pageSize();
    }

    public int payloadSize() {
        return this.delegate.payloadSize();
    }

    public int pageReservedBytes() {
        return this.delegate.pageReservedBytes();
    }

    public long fileSize() throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        return this.delegate.fileSize();
    }

    public Path path() {
        return this.delegate.path();
    }

    public void flushAndForce(FileFlushEvent flushEvent) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce(flushEvent);
    }

    public long getLastPageId() throws IOException {
        this.adversary.injectFailure(IllegalStateException.class);
        return this.delegate.getLastPageId();
    }

    public void increaseLastPageIdTo(long newLastPageId) {
        this.delegate.increaseLastPageIdTo(newLastPageId);
    }

    public void close() {
        this.adversary.injectFailure(NoSuchFileException.class, SecurityException.class);
        this.delegate.close();
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
        this.delegate.setDeleteOnClose(deleteOnClose);
    }

    public boolean isDeleteOnClose() {
        return this.delegate.isDeleteOnClose();
    }

    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    public PageFileCounters pageFileCounters() {
        return this.delegate.pageFileCounters();
    }

    public boolean isMultiVersioned() {
        return this.delegate.isMultiVersioned();
    }

    public void truncate(long pagesToKeep, FileTruncateEvent fileTruncateEvent) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.truncate(pagesToKeep, fileTruncateEvent);
    }

    public String toString() {
        return "AdversarialPagedFile{delegate=" + this.delegate + "}";
    }
}

