/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPagedFile;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.EvictionBouncer;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.util.VisibleForTesting;

public class AdversarialPageCache
extends DelegatingPageCache {
    private final Adversary adversary;

    public AdversarialPageCache(PageCache delegate, Adversary adversary) {
        super(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    @Override
    public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ioController, EvictionBouncer evictionBouncer, VersionStorage versionStorage) throws IOException {
        if (openOptions.contains((Object)StandardOpenOption.CREATE)) {
            this.adversary.injectFailure(IOException.class, SecurityException.class);
        } else {
            this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        }
        PagedFile pagedFile = this.getDelegate().map(path, pageSize, databaseName, openOptions, ioController, evictionBouncer, versionStorage);
        return new AdversarialPagedFile(pagedFile, this.adversary);
    }

    @Override
    public Optional<PagedFile> getExistingMapping(Path path) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        Optional optional = this.getDelegate().getExistingMapping(path);
        return optional.map(pagedFile -> new AdversarialPagedFile((PagedFile)pagedFile, this.adversary));
    }

    @Override
    public List<PagedFile> listExistingMappings() throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        return this.getDelegate().listExistingMappings().stream().map(file -> new AdversarialPagedFile((PagedFile)file, this.adversary)).map(PagedFile.class::cast).toList();
    }

    @Override
    public void flushAndForce(DatabaseFlushEvent flushEvent) throws IOException {
        this.adversary.injectFailure(NoSuchFileException.class, IOException.class, SecurityException.class);
        this.getDelegate().flushAndForce(flushEvent);
    }

    @Override
    public void close() {
        this.adversary.injectFailure(IllegalStateException.class);
        this.getDelegate().close();
    }

    @VisibleForTesting
    public Adversary adversary() {
        return this.adversary;
    }
}

