/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.adversaries.Adversary;

public abstract class AbstractAdversary
implements Adversary {
    protected final Random rng = new Random();
    private volatile Throwable adversaryException;

    AbstractAdversary() {
    }

    public void setSeed(long seed) {
        this.rng.setSeed(seed);
    }

    protected void throwOneOf(Class<? extends Throwable> ... types) {
        int choice = this.rng.nextInt(types.length);
        Class<? extends Throwable> type = types[choice];
        try {
            this.adversaryException = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)new Exception("Failed to instantiate failure", e));
        }
        ExceptionUtils.rethrow((Throwable)this.adversaryException);
    }

    @Override
    public Optional<Throwable> getLastAdversaryException() {
        return Optional.ofNullable(this.adversaryException);
    }
}

