/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;

public class DelegatingPageSwapper
implements PageSwapper {
    private final PageSwapper delegate;

    public DelegatingPageSwapper(PageSwapper delegate) {
        this.delegate = delegate;
    }

    public long read(long filePageId, long bufferAddress) throws IOException {
        return this.delegate.read(filePageId, bufferAddress);
    }

    public long read(long filePageId, long bufferAddress, int bufferLength) throws IOException {
        return this.delegate.read(filePageId, bufferAddress, bufferLength);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void evicted(long pageRef, long filePageId) {
        this.delegate.evicted(pageRef, filePageId);
    }

    public void force() throws IOException {
        this.delegate.force();
    }

    public Path path() {
        return this.delegate.path();
    }

    public long write(long filePageId, long bufferAddress) throws IOException {
        return this.delegate.write(filePageId, bufferAddress);
    }

    public long write(long filePageId, long bufferAddress, int bufferLength) throws IOException {
        return this.delegate.write(filePageId, bufferAddress, bufferLength);
    }

    public void asyncWrite(AsyncBlockAccessor accessor, long pageRef, long filePageId, long bufferAddress) throws IOException {
        this.delegate.asyncWrite(accessor, pageRef, filePageId, bufferAddress);
    }

    public long getLastPageId() throws IOException {
        return this.delegate.getLastPageId();
    }

    public void truncate() throws IOException {
        this.delegate.truncate();
    }

    public void truncate(long size) throws IOException {
        this.delegate.truncate(size);
    }

    public boolean canAllocate() {
        return this.delegate.canAllocate();
    }

    public void allocate(long newFileSize) throws IOException {
        this.delegate.allocate(newFileSize);
    }

    public int swapperId() {
        return this.delegate.swapperId();
    }

    public PageFileSwapperTracer fileSwapperTracer() {
        return this.delegate.fileSwapperTracer();
    }

    public boolean isPageFlushable(long pageRef) {
        return this.delegate.isPageFlushable(pageRef);
    }

    public void closeAndDelete() throws IOException {
        this.delegate.closeAndDelete();
    }

    public long read(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        return this.delegate.read(startFilePageId, bufferAddresses, bufferLengths, length);
    }

    public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        return this.delegate.write(startFilePageId, bufferAddresses, bufferLengths, length);
    }

    public void asyncWrite(AsyncBlockAccessor accessor, long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, long[] pageRefs, long[] flushStamps, int pagesToFlush) throws IOException {
        this.delegate.asyncWrite(accessor, startFilePageId, bufferAddresses, bufferLengths, length, pageRefs, flushStamps, pagesToFlush);
    }
}

