/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;

public class ChannelOutputStream
extends OutputStream {
    private final StoreChannel channel;
    private final ScopedBuffer scopedBuffer;
    private final ByteBuffer buffer;

    public ChannelOutputStream(StoreChannel channel, boolean append, MemoryTracker memoryTracker, int bufferSize) throws IOException {
        this.scopedBuffer = new HeapScopedBuffer(Math.toIntExact(bufferSize), ByteOrder.LITTLE_ENDIAN, memoryTracker);
        this.buffer = this.scopedBuffer.getBuffer();
        this.channel = channel;
        if (append) {
            this.channel.position(this.channel.size());
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.clear();
        this.buffer.put((byte)b);
        this.buffer.flip();
        this.channel.writeAll(this.buffer);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int written = 0; written < len; written += this.channel.write(this.buffer)) {
            this.buffer.clear();
            this.buffer.put(b, off + written, Math.min(len - written, this.buffer.capacity()));
            this.buffer.flip();
        }
    }

    @Override
    public void close() throws IOException {
        this.scopedBuffer.close();
        this.channel.close();
    }
}

