/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import org.neo4j.driver.exceptions.value.ValueException;
import org.neo4j.driver.internal.value.mapping.Argument;
import org.neo4j.driver.internal.value.mapping.ObjectMetadata;

class ObjectInstantiator {
    ObjectInstantiator() {
    }

    <T> T instantiate(ObjectMetadata<T> metadata) {
        Constructor<T> constructor = metadata.constructor();
        String targetTypeName = constructor.getDeclaringClass().getName();
        Object[] initargs = this.initargs(targetTypeName, metadata.arguments());
        try {
            return constructor.newInstance(initargs);
        }
        catch (Throwable e) {
            throw new ValueException("Failed to instantiate '%s'".formatted(targetTypeName), e);
        }
    }

    private Object[] initargs(String targetTypeName, List<Argument> arguments) {
        Object[] initargs = new Object[arguments.size()];
        for (int i = 0; i < initargs.length; ++i) {
            Argument argument = arguments.get(i);
            Type type = argument.type();
            try {
                initargs[i] = argument.value().as(type);
                continue;
            }
            catch (Throwable e) {
                throw new ValueException("Failed to map '%s' property to '%s' for '%s' instantiation".formatted(argument.propertyName(), type.getTypeName(), targetTypeName), e);
            }
        }
        return initargs;
    }
}

