/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactivestreams;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.reactive.AbstractReactiveSession;
import org.neo4j.driver.internal.reactivestreams.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactivestreams.DelegatingReactiveTransactionContext;
import org.neo4j.driver.internal.reactivestreams.InternalReactiveResult;
import org.neo4j.driver.internal.reactivestreams.InternalReactiveTransaction;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.reactivestreams.ReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveSession;
import org.neo4j.driver.reactivestreams.ReactiveTransaction;
import org.neo4j.driver.reactivestreams.ReactiveTransactionCallback;
import org.reactivestreams.Publisher;

public class InternalReactiveSession
extends AbstractReactiveSession<ReactiveTransaction>
implements ReactiveSession,
BaseReactiveQueryRunner {
    private final DriverObservationProvider observationProvider;

    public InternalReactiveSession(NetworkSession session, DriverObservationProvider observationProvider) {
        super(session);
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public ReactiveTransaction createTransaction(UnmanagedTransaction unmanagedTransaction) {
        return new InternalReactiveTransaction(unmanagedTransaction, this.observationProvider);
    }

    @Override
    public Publisher<Void> closeTransaction(ReactiveTransaction transaction, boolean commit, Observation parentObservation) {
        return ((InternalReactiveTransaction)transaction).close(commit, parentObservation);
    }

    @Override
    public Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config) {
        return this.beginTransaction(config, null, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION));
    }

    public Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork) {
        Observation beginObservation = this.observationProvider.beginTransaction(ReactiveTransaction.class);
        return ObservationUtil.observeStreams(beginObservation, this.doBeginTransaction(config, txType, apiTelemetryWork, beginObservation));
    }

    @Override
    public <T> Publisher<T> executeRead(ReactiveTransactionCallback<? extends Publisher<T>> callback, TransactionConfig config) {
        return this.runTransaction(AccessMode.READ, tx -> (Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)), config, ReactiveSession.class, this.observationProvider);
    }

    @Override
    public <T> Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Publisher<T>> callback, TransactionConfig config) {
        return this.runTransaction(AccessMode.WRITE, tx -> (Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)), config, ReactiveSession.class, this.observationProvider);
    }

    @Override
    public Publisher<ReactiveResult> run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Publisher<ReactiveResult> run(Query query, TransactionConfig config) {
        Observation runObservation = this.observationProvider.sessionRun(ReactiveSession.class, query.text(), query.parameters());
        Publisher<ReactiveResult> publisher = this.run(query, config, result -> new InternalReactiveResult((RxResultCursor)result, this.observationProvider), runObservation);
        return ObservationUtil.observeStreams(runObservation, publisher);
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return new HashSet<Bookmark>(this.session.lastBookmarks());
    }

    @Override
    public <T> Publisher<T> close() {
        Observation closeObservation = this.observationProvider.sessionClose(ReactiveSession.class);
        return ObservationUtil.observeStreams(closeObservation, this.doClose(closeObservation));
    }
}

