/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.AuthTokens;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.SecurityRetryableException;
import org.neo4j.driver.internal.adaptedbolt.BoltFailureExceptionWithNeo4jException;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.value.BoltValueFactory;

public final class BoltAuthTokenManager
implements org.neo4j.bolt.connection.pooled.AuthTokenManager {
    private final AuthTokenManager authTokenManager;
    private final BoltValueFactory valueFactory;
    private final ErrorMapper errorMapper;

    public BoltAuthTokenManager(AuthTokenManager authTokenManager, BoltValueFactory valueFactory, ErrorMapper errorMapper) {
        this.authTokenManager = Objects.requireNonNull(authTokenManager);
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.errorMapper = Objects.requireNonNull(errorMapper);
    }

    public CompletionStage<AuthToken> getToken() {
        return this.authTokenManager.getToken().thenApply(authToken -> AuthTokens.custom(this.valueFactory.toBoltMap(((InternalAuthToken)authToken).toMap())));
    }

    public BoltFailureException handleBoltFailureException(AuthToken authToken, BoltFailureException exception) {
        Neo4jException neo4jException = this.errorMapper.mapBoltFailureException(exception);
        if (neo4jException instanceof SecurityException) {
            SecurityException securityException = (SecurityException)neo4jException;
            InternalAuthToken mappedAuthToken = new InternalAuthToken(BoltValueFactory.getInstance().toDriverMap(authToken.asMap()));
            if (this.authTokenManager.handleSecurityException(mappedAuthToken, securityException)) {
                neo4jException = new SecurityRetryableException(securityException);
            }
        }
        return new BoltFailureExceptionWithNeo4jException(exception, neo4jException);
    }
}

