/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.BoltValue;
import org.neo4j.driver.internal.value.ValueAdapter;

public abstract class BooleanValue
extends ValueAdapter {
    public static final BooleanValue TRUE = new TrueValue();
    public static final BooleanValue FALSE = new FalseValue();

    private BooleanValue() {
    }

    public static BooleanValue fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public abstract Boolean asObject();

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.BOOLEAN();
    }

    @Override
    public int hashCode() {
        Boolean value = this.asBoolean() ? Boolean.TRUE : Boolean.FALSE;
        return value.hashCode();
    }

    private static class TrueValue
    extends BooleanValue {
        private TrueValue() {
        }

        @Override
        public Boolean asObject() {
            return Boolean.TRUE;
        }

        @Override
        public boolean asBoolean() {
            return true;
        }

        @Override
        public <T> T as(Class<T> targetClass) {
            if (targetClass.isAssignableFrom(Boolean.class)) {
                return targetClass.cast(Boolean.TRUE);
            }
            if (targetClass.isAssignableFrom(Boolean.TYPE)) {
                return (T)Boolean.TRUE;
            }
            throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
        }

        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == TRUE;
        }

        @Override
        public String toString() {
            return "TRUE";
        }

        @Override
        public BoltValue asBoltValue() {
            return new BoltValue(this, Type.BOOLEAN);
        }
    }

    private static class FalseValue
    extends BooleanValue {
        private FalseValue() {
        }

        @Override
        public Boolean asObject() {
            return Boolean.FALSE;
        }

        @Override
        public boolean asBoolean() {
            return false;
        }

        @Override
        public <T> T as(Class<T> targetClass) {
            if (targetClass.isAssignableFrom(Boolean.class)) {
                return targetClass.cast(Boolean.FALSE);
            }
            if (targetClass.isAssignableFrom(Boolean.TYPE)) {
                return (T)Boolean.FALSE;
            }
            throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
        }

        @Override
        public boolean isFalse() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == FALSE;
        }

        @Override
        public String toString() {
            return "FALSE";
        }

        @Override
        public BoltValue asBoltValue() {
            return new BoltValue(this, Type.BOOLEAN);
        }
    }
}

