/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.pool.AuthContext;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.v51.BoltProtocolV51;

public class HandshakeCompletedListener
implements ChannelFutureListener {
    private final String userAgent;
    private final RoutingContext routingContext;
    private final ChannelPromise connectionInitializedPromise;
    private final NotificationConfig notificationConfig;
    private final Clock clock;

    public HandshakeCompletedListener(String userAgent, RoutingContext routingContext, ChannelPromise connectionInitializedPromise, NotificationConfig notificationConfig, Clock clock) {
        Objects.requireNonNull(clock, "clock must not be null");
        this.userAgent = Objects.requireNonNull(userAgent);
        this.routingContext = routingContext;
        this.connectionInitializedPromise = Objects.requireNonNull(connectionInitializedPromise);
        this.notificationConfig = notificationConfig;
        this.clock = clock;
    }

    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            BoltProtocol protocol = BoltProtocol.forChannel(future.channel());
            if (BoltProtocolV51.VERSION.compareTo(protocol.version()) > 0) {
                Channel channel = this.connectionInitializedPromise.channel();
                AuthContext authContext = ChannelAttributes.authContext(channel);
                authContext.getAuthTokenManager().getToken().whenCompleteAsync((authToken, throwable) -> {
                    if (throwable != null) {
                        this.connectionInitializedPromise.setFailure(throwable);
                    } else {
                        authContext.initiateAuth((AuthToken)authToken);
                        authContext.setValidToken((AuthToken)authToken);
                        protocol.initializeChannel(this.userAgent, (AuthToken)authToken, this.routingContext, this.connectionInitializedPromise, this.notificationConfig, this.clock);
                    }
                }, (Executor)channel.eventLoop());
            } else {
                protocol.initializeChannel(this.userAgent, null, this.routingContext, this.connectionInitializedPromise, this.notificationConfig, this.clock);
            }
        } else {
            this.connectionInitializedPromise.setFailure(future.cause());
        }
    }
}

