/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.NoOpBookmarkManager;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;

public class SessionFactoryImpl
implements SessionFactory {
    private final ConnectionProvider connectionProvider;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;
    private final long defaultFetchSize;
    private final NotificationConfig driverNotificationConfig;

    SessionFactoryImpl(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
        this.defaultFetchSize = config.fetchSize();
        this.driverNotificationConfig = config.notificationConfig();
    }

    @Override
    public NetworkSession newInstance(SessionConfig sessionConfig, AuthToken overrideAuthToken) {
        return this.createSession(this.connectionProvider, this.retryLogic, this.parseDatabaseName(sessionConfig), sessionConfig.defaultAccessMode(), this.toDistinctSet(sessionConfig.bookmarks()), this.parseFetchSize(sessionConfig), sessionConfig.impersonatedUser().orElse(null), this.logging, sessionConfig.bookmarkManager().orElse(NoOpBookmarkManager.INSTANCE), sessionConfig.notificationConfig(), overrideAuthToken);
    }

    private Set<Bookmark> toDistinctSet(Iterable<Bookmark> bookmarks) {
        HashSet<Bookmark> set = new HashSet<Bookmark>();
        if (bookmarks != null) {
            for (Bookmark bookmark : bookmarks) {
                if (bookmark == null) continue;
                Set<String> values = bookmark.values();
                int size = values.size();
                if (size == 1) {
                    set.add(bookmark);
                    continue;
                }
                if (size <= 1) continue;
                for (String value : values) {
                    set.add(Bookmark.from(value));
                }
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private long parseFetchSize(SessionConfig sessionConfig) {
        return sessionConfig.fetchSize().orElse(this.defaultFetchSize);
    }

    private DatabaseName parseDatabaseName(SessionConfig sessionConfig) {
        return sessionConfig.database().flatMap(name -> Optional.of(DatabaseNameUtil.database(name))).orElse(DatabaseNameUtil.defaultDatabase());
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.connectionProvider.verifyConnectivity();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionProvider.close();
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb() {
        return this.connectionProvider.supportsMultiDb();
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.connectionProvider.supportsSessionAuth();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    private NetworkSession createSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, Set<Bookmark> bookmarks, long fetchSize, String impersonatedUser, Logging logging, BookmarkManager bookmarkManager, NotificationConfig notificationConfig, AuthToken authToken) {
        Objects.requireNonNull(bookmarks, "bookmarks may not be null");
        Objects.requireNonNull(bookmarkManager, "bookmarkManager may not be null");
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, notificationConfig, authToken) : new NetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, notificationConfig, authToken);
    }
}

