/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.internal.util.LockUtil;

public final class Neo4jBookmarkManager
implements BookmarkManager {
    private static final long serialVersionUID = 6615186840717102303L;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Set<Bookmark> bookmarks;
    private final Consumer<Set<Bookmark>> updateListener;
    private final Supplier<Set<Bookmark>> bookmarksSupplier;

    public Neo4jBookmarkManager(Set<Bookmark> initialBookmarks, Consumer<Set<Bookmark>> updateListener, Supplier<Set<Bookmark>> bookmarksSupplier) {
        Objects.requireNonNull(initialBookmarks, "initialBookmarks must not be null");
        this.bookmarks = new HashSet<Bookmark>(initialBookmarks);
        this.updateListener = updateListener;
        this.bookmarksSupplier = bookmarksSupplier;
    }

    @Override
    public void updateBookmarks(Set<Bookmark> previousBookmarks, Set<Bookmark> newBookmarks) {
        Set immutableBookmarks = LockUtil.executeWithLock(this.rwLock.writeLock(), () -> {
            this.bookmarks.removeAll(previousBookmarks);
            this.bookmarks.addAll(newBookmarks);
            return Collections.unmodifiableSet(this.bookmarks);
        });
        if (this.updateListener != null) {
            this.updateListener.accept(immutableBookmarks);
        }
    }

    @Override
    public Set<Bookmark> getBookmarks() {
        Set immutableBookmarks = LockUtil.executeWithLock(this.rwLock.readLock(), () -> Collections.unmodifiableSet(this.bookmarks));
        if (this.bookmarksSupplier != null) {
            HashSet bookmarks = new HashSet(immutableBookmarks);
            bookmarks.addAll(this.bookmarksSupplier.get());
            immutableBookmarks = Collections.unmodifiableSet(bookmarks);
        }
        return immutableBookmarks;
    }
}

