/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.RoutingControl;
import org.neo4j.driver.util.Experimental;

@Experimental
public final class QueryConfig
implements Serializable {
    private static final long serialVersionUID = -2632780731598141754L;
    private static final QueryConfig DEFAULT = QueryConfig.builder().build();
    private final RoutingControl routing;
    private final String database;
    private final String impersonatedUser;
    private final BookmarkManager bookmarkManager;
    private final boolean useDefaultBookmarkManager;

    public static QueryConfig defaultConfig() {
        return DEFAULT;
    }

    private QueryConfig(Builder builder) {
        this.routing = builder.routing;
        this.database = builder.database;
        this.impersonatedUser = builder.impersonatedUser;
        this.bookmarkManager = builder.bookmarkManager;
        this.useDefaultBookmarkManager = builder.useDefaultBookmarkManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RoutingControl routing() {
        return this.routing;
    }

    public Optional<String> database() {
        return Optional.ofNullable(this.database);
    }

    public Optional<String> impersonatedUser() {
        return Optional.ofNullable(this.impersonatedUser);
    }

    public Optional<BookmarkManager> bookmarkManager(BookmarkManager defaultBookmarkManager) {
        Objects.requireNonNull(defaultBookmarkManager, "defaultBookmarkManager must not be null");
        return this.useDefaultBookmarkManager ? Optional.of(defaultBookmarkManager) : Optional.ofNullable(this.bookmarkManager);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryConfig that = (QueryConfig)o;
        return this.useDefaultBookmarkManager == that.useDefaultBookmarkManager && this.routing == that.routing && Objects.equals(this.database, that.database) && Objects.equals(this.impersonatedUser, that.impersonatedUser) && Objects.equals(this.bookmarkManager, that.bookmarkManager);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.routing, this.database, this.impersonatedUser, this.bookmarkManager, this.useDefaultBookmarkManager});
    }

    public String toString() {
        return "QueryConfig{routing=" + this.routing + ", database='" + this.database + "', impersonatedUser='" + this.impersonatedUser + "', bookmarkManager=" + this.bookmarkManager + ", useDefaultBookmarkManager=" + this.useDefaultBookmarkManager + "}";
    }

    public static final class Builder {
        private RoutingControl routing = RoutingControl.WRITERS;
        private String database;
        private String impersonatedUser;
        private BookmarkManager bookmarkManager;
        private boolean useDefaultBookmarkManager = true;

        private Builder() {
        }

        public Builder withRouting(RoutingControl routing) {
            Objects.requireNonNull(routing, "routing must not be null");
            this.routing = routing;
            return this;
        }

        public Builder withDatabase(String database) {
            Objects.requireNonNull(database, "database must not be null");
            if (database.isEmpty()) {
                throw new IllegalArgumentException(String.format("Illegal database '%s'", database));
            }
            this.database = database;
            return this;
        }

        public Builder withImpersonatedUser(String impersonatedUser) {
            Objects.requireNonNull(impersonatedUser, "impersonatedUser must not be null");
            if (impersonatedUser.isEmpty()) {
                throw new IllegalArgumentException(String.format("Illegal impersonated user '%s'", impersonatedUser));
            }
            this.impersonatedUser = impersonatedUser;
            return this;
        }

        public Builder withBookmarkManager(BookmarkManager bookmarkManager) {
            this.useDefaultBookmarkManager = false;
            this.bookmarkManager = bookmarkManager;
            return this;
        }

        public QueryConfig build() {
            return new QueryConfig(this);
        }
    }
}

