/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.BaseSession;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Query;
import org.neo4j.driver.QueryConfig;
import org.neo4j.driver.QueryTask;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.internal.InternalQueryTask;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.async.InternalAsyncSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.reactive.InternalReactiveSession;
import org.neo4j.driver.internal.reactive.InternalRxSession;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactivestreams.ReactiveSession;
import org.neo4j.driver.types.TypeSystem;

public class InternalDriver
implements Driver {
    private final BookmarkManager queryBookmarkManager;
    private final SecurityPlan securityPlan;
    private final SessionFactory sessionFactory;
    private final Logger log;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final MetricsProvider metricsProvider;

    InternalDriver(BookmarkManager queryBookmarkManager, SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Logging logging) {
        this.queryBookmarkManager = queryBookmarkManager;
        this.securityPlan = securityPlan;
        this.sessionFactory = sessionFactory;
        this.metricsProvider = metricsProvider;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public QueryTask queryTask(String query) {
        return new InternalQueryTask(this, new Query(query), QueryConfig.defaultConfig());
    }

    @Override
    public BookmarkManager queryBookmarkManager() {
        return this.queryBookmarkManager;
    }

    @Override
    public <T extends BaseSession> T session(Class<T> sessionClass, SessionConfig sessionConfig) {
        BaseSession session;
        Objects.requireNonNull(sessionClass, "sessionClass must not be null");
        Objects.requireNonNull(sessionClass, "sessionConfig must not be null");
        if (Session.class.isAssignableFrom(sessionClass)) {
            session = new InternalSession(this.newSession(sessionConfig));
        } else if (AsyncSession.class.isAssignableFrom(sessionClass)) {
            session = new InternalAsyncSession(this.newSession(sessionConfig));
        } else if (org.neo4j.driver.reactive.ReactiveSession.class.isAssignableFrom(sessionClass)) {
            session = new InternalReactiveSession(this.newSession(sessionConfig));
        } else if (ReactiveSession.class.isAssignableFrom(sessionClass)) {
            session = new org.neo4j.driver.internal.reactivestreams.InternalReactiveSession(this.newSession(sessionConfig));
        } else if (RxSession.class.isAssignableFrom(sessionClass)) {
            session = new InternalRxSession(this.newSession(sessionConfig));
        } else {
            throw new IllegalArgumentException(String.format("Unsupported session type '%s'", sessionClass.getCanonicalName()));
        }
        return (T)session;
    }

    @Override
    public Metrics metrics() {
        return this.metricsProvider.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metricsProvider != DevNullMetricsProvider.INSTANCE;
    }

    @Override
    public boolean isEncrypted() {
        this.assertOpen();
        return this.securityPlan.requiresEncryption();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync());
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.info("Closing driver instance %s", this.hashCode());
            return this.sessionFactory.close();
        }
        return Futures.completedWithNull();
    }

    @Override
    public final TypeSystem defaultTypeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    @Override
    public CompletionStage<Void> verifyConnectivityAsync() {
        return this.sessionFactory.verifyConnectivity();
    }

    @Override
    public boolean supportsMultiDb() {
        return Futures.blockingGet(this.supportsMultiDbAsync());
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDbAsync() {
        return this.sessionFactory.supportsMultiDb();
    }

    @Override
    public void verifyConnectivity() {
        Futures.blockingGet(this.verifyConnectivityAsync());
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private static RuntimeException driverCloseException() {
        return new IllegalStateException("This driver instance has already been closed");
    }

    public NetworkSession newSession(SessionConfig config) {
        this.assertOpen();
        NetworkSession session = this.sessionFactory.newInstance(config);
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
        return session;
    }

    private void assertOpen() {
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
    }
}

