/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Map;
import java.util.Optional;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.InternalGqlStatusObject;
import org.neo4j.driver.summary.GqlNotification;
import org.neo4j.driver.summary.InputPosition;

public final class InternalGqlNotification
extends InternalGqlStatusObject
implements GqlNotification {
    private final InputPosition position;
    private final NotificationSeverity severityLevel;
    private final String rawSeverityLevel;
    private final NotificationClassification classification;
    private final String rawClassification;

    public InternalGqlNotification(String gqlStatus, String statusDescription, Map<String, Value> diagnosticRecord, InputPosition position, NotificationSeverity severityLevel, String rawSeverityLevel, NotificationClassification classification, String rawClassification) {
        super(gqlStatus, statusDescription, diagnosticRecord);
        this.position = position;
        this.severityLevel = severityLevel;
        this.rawSeverityLevel = rawSeverityLevel;
        this.classification = classification;
        this.rawClassification = rawClassification;
    }

    @Override
    public Optional<InputPosition> position() {
        return Optional.ofNullable(this.position);
    }

    @Override
    public Optional<NotificationSeverity> severity() {
        return Optional.ofNullable(this.severityLevel);
    }

    @Override
    public Optional<String> rawSeverity() {
        return Optional.ofNullable(this.rawSeverityLevel);
    }

    @Override
    public Optional<NotificationClassification> classification() {
        return Optional.ofNullable(this.classification);
    }

    @Override
    public Optional<String> rawClassification() {
        return Optional.ofNullable(this.rawClassification);
    }

    @Override
    public String toString() {
        return "InternalGqlNotification{gqlStatus='" + this.gqlStatus + "', statusDescription='" + this.statusDescription + "', diagnosticRecord=" + this.diagnosticRecord + "}";
    }
}

