/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.mapping.Argument;
import org.neo4j.driver.internal.value.mapping.ObjectMetadata;
import org.neo4j.driver.mapping.Property;
import org.neo4j.driver.types.MapAccessor;

class ConstructorFinder {
    ConstructorFinder() {
    }

    public <T> Optional<ObjectMetadata<T>> findConstructor(MapAccessor mapAccessor, Class<T> targetClass) {
        PropertiesMatch<?> bestPropertiesMatch = null;
        Constructor<?>[] constructors = targetClass.getDeclaredConstructors();
        int propertyNamesSize = mapAccessor.size();
        for (Constructor<?> constructor : constructors) {
            boolean accessible = false;
            try {
                accessible = constructor.canAccess(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!accessible) continue;
            PropertiesMatch<?> matchNumbers = this.matchPropertyNames(mapAccessor, constructor);
            if ((bestPropertiesMatch == null || matchNumbers.match() >= bestPropertiesMatch.match() && matchNumbers.mismatch() < bestPropertiesMatch.mismatch()) && (bestPropertiesMatch = matchNumbers).match() == propertyNamesSize && bestPropertiesMatch.mismatch() == 0) break;
        }
        if (bestPropertiesMatch == null || bestPropertiesMatch.match() == 0) {
            return Optional.empty();
        }
        return Optional.of(new ObjectMetadata(bestPropertiesMatch.constructor(), bestPropertiesMatch.arguments()));
    }

    private <T> PropertiesMatch<T> matchPropertyNames(MapAccessor mapAccessor, Constructor<T> constructor) {
        int match = 0;
        int mismatch = 0;
        Parameter[] parameters = constructor.getParameters();
        ArrayList<Argument> arguments = new ArrayList<Argument>(parameters.length);
        for (Parameter parameter : parameters) {
            Property propertyNameAnnotation = parameter.getAnnotation(Property.class);
            String propertyName = propertyNameAnnotation != null ? propertyNameAnnotation.value() : parameter.getName();
            Value value = mapAccessor.get(propertyName);
            if (value != null) {
                ++match;
            } else {
                ++mismatch;
            }
            arguments.add(new Argument(propertyName, parameter.getParameterizedType(), value != null ? (InternalValue)value : (InternalValue)Values.NULL));
        }
        return new PropertiesMatch<T>(match, mismatch, constructor, arguments);
    }

    private record PropertiesMatch<T>(int match, int mismatch, Constructor<T> constructor, List<Argument> arguments) {
    }
}

