/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.async.DelegatingBoltConnection;
import org.neo4j.driver.internal.async.TerminationAwareResponseHandler;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.util.Futures;

final class TerminationAwareBoltConnection
extends DelegatingBoltConnection {
    private final Logging logging;
    private final Logger log;
    private final TerminationAwareStateLockingExecutor executor;
    private final Consumer<Throwable> throwableConsumer;

    public TerminationAwareBoltConnection(Logging logging, DriverBoltConnection delegate, TerminationAwareStateLockingExecutor executor, Consumer<Throwable> throwableConsumer) {
        super(delegate);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.executor = Objects.requireNonNull(executor);
        this.throwableConsumer = Objects.requireNonNull(throwableConsumer);
    }

    public CompletionStage<DriverBoltConnection> clearAndReset() {
        CompletableFuture<DriverBoltConnection> future = new CompletableFuture<DriverBoltConnection>();
        TerminationAwareBoltConnection thisVal = this;
        this.delegate.onLoop(() -> this.executor.execute(ignored -> this.clearAndResetBolt(future))).thenCompose(Function.identity()).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                this.throwableConsumer.accept((Throwable)throwable);
                future.completeExceptionally((Throwable)throwable);
            }
        });
        return future;
    }

    private CompletionStage<Void> clearAndResetBolt(final CompletableFuture<DriverBoltConnection> future) {
        final TerminationAwareBoltConnection thisVal = this;
        return this.delegate.clear().thenCompose(DriverBoltConnection::reset).thenCompose(conn -> conn.flush(new DriverResponseHandler(){
            Throwable throwable = null;

            @Override
            public void onError(Throwable throwable) {
                TerminationAwareBoltConnection.this.log.error("Unexpected error occurred while resetting connection", throwable);
                TerminationAwareBoltConnection.this.throwableConsumer.accept(throwable);
                this.throwable = throwable;
            }

            @Override
            public void onComplete() {
                if (this.throwable != null) {
                    future.completeExceptionally(this.throwable);
                } else {
                    future.complete(thisVal);
                }
            }
        }));
    }

    @Override
    public CompletionStage<Void> flush(DriverResponseHandler handler) {
        return this.delegate.onLoop(() -> this.executor.execute(causeOfTermination -> this.flushBolt((Throwable)causeOfTermination, handler))).thenCompose(Function.identity());
    }

    private CompletionStage<Void> flushBolt(Throwable causeOfTermination, DriverResponseHandler handler) {
        if (causeOfTermination == null) {
            this.log.trace("This connection is active, will flush", new Object[0]);
            TerminationAwareResponseHandler terminationAwareResponseHandler = new TerminationAwareResponseHandler(this.logging, handler, this.executor, this.throwableConsumer);
            return this.delegate.flush(terminationAwareResponseHandler).handle((ignored, flushThrowable) -> {
                if ((flushThrowable = Futures.completionExceptionCause(flushThrowable)) != null) {
                    Throwable flushThrowableRef;
                    if (this.log.isTraceEnabled()) {
                        this.log.error("The flush has failed", (Throwable)flushThrowable);
                    }
                    if ((flushThrowable = this.executor.execute(arg_0 -> this.lambda$flushBolt$6(flushThrowableRef = flushThrowable, arg_0))) instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)flushThrowable;
                        throw runtimeException;
                    }
                    throw new CompletionException((Throwable)flushThrowable);
                }
                return ignored;
            });
        }
        return this.delegate.clear().thenCompose(ignored -> CompletableFuture.failedStage(causeOfTermination));
    }

    private /* synthetic */ Throwable lambda$flushBolt$6(Throwable flushThrowableRef, Throwable existingThrowable) {
        if (existingThrowable != null) {
            this.log.trace("The flush has failed, but there is an existing %s", existingThrowable);
            return existingThrowable;
        }
        this.throwableConsumer.accept(flushThrowableRef);
        return flushThrowableRef;
    }
}

