/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.encode;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.api.values.ValueFactory;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.Message;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageEncoder;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.ValuePacker;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.RouteMessage;
import org.neo4j.driver.internal.bolt.basicimpl.util.Preconditions;

public class RouteV44MessageEncoder
implements MessageEncoder {
    @Override
    public void encode(Message message, ValuePacker packer, ValueFactory valueFactory) throws IOException {
        Preconditions.checkArgument(message, RouteMessage.class);
        RouteMessage routeMessage = (RouteMessage)message;
        packer.packStructHeader(3, message.signature());
        packer.pack(routeMessage.routingContext());
        packer.pack(valueFactory.value(routeMessage.bookmarks()));
        Map<String, Value> params = routeMessage.impersonatedUser() != null && routeMessage.databaseName() == null ? Collections.singletonMap("imp_user", valueFactory.value(routeMessage.impersonatedUser())) : (routeMessage.databaseName() != null ? Collections.singletonMap("db", valueFactory.value(routeMessage.databaseName())) : Collections.emptyMap());
        packer.pack(params);
    }
}

