/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;

public class RollbackTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> rollbackFuture;

    public RollbackTxResponseHandler(CompletableFuture<Void> rollbackFuture) {
        this.rollbackFuture = Objects.requireNonNull(rollbackFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.rollbackFuture.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.rollbackFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction rollback is not expected to receive records: " + Arrays.toString(fields));
    }
}

