/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.Logging;
import org.neo4j.driver.RevocationCheckingStrategy;
import org.neo4j.driver.internal.bolt.api.ssl.SSLContexts;
import org.neo4j.driver.internal.bolt.api.ssl.TrustManagerFactories;
import org.neo4j.driver.internal.security.SSLContextManager;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Futures;

public class SecurityPlanImpl
implements SecurityPlan {
    private final boolean requiresEncryption;
    private final boolean requiresClientAuth;
    private final boolean requiresHostnameVerification;
    private final RevocationCheckingStrategy revocationCheckingStrategy;
    private final Supplier<CompletionStage<SSLContext>> sslContextSupplier;

    public static SecurityPlan forAllCertificates(boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy, ClientCertificateManager clientCertificateManager, Logging logging) throws NoSuchAlgorithmException, KeyManagementException {
        return new SecurityPlanImpl(SSLContexts::forAnyCertificate, requiresHostnameVerification, revocationCheckingStrategy, clientCertificateManager, logging);
    }

    public static SecurityPlan forCustomCASignedCertificates(List<File> certFiles, boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy, ClientCertificateManager clientCertificateManager, Logging logging) throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactories.forCertificates(certFiles, SecurityPlanImpl.map(revocationCheckingStrategy));
        return new SecurityPlanImpl(keyManagers -> SSLContexts.forTrustManagers(keyManagers, trustManagerFactory.getTrustManagers()), requiresHostnameVerification, revocationCheckingStrategy, clientCertificateManager, logging);
    }

    public static SecurityPlan forSystemCASignedCertificates(boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy, ClientCertificateManager clientCertificateManager, Logging logging) throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactories.forSystemCertificates(SecurityPlanImpl.map(revocationCheckingStrategy));
        return new SecurityPlanImpl(keyManagers -> SSLContexts.forTrustManagers(keyManagers, trustManagerFactory.getTrustManagers()), requiresHostnameVerification, revocationCheckingStrategy, clientCertificateManager, logging);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlanImpl();
    }

    private SecurityPlanImpl(SecurityPlan.SSLContextSupplier sslContextSupplier, boolean requiresHostnameVerification, RevocationCheckingStrategy revocationCheckingStrategy, ClientCertificateManager clientCertificateManager, Logging logging) throws NoSuchAlgorithmException, KeyManagementException {
        this.requiresEncryption = true;
        this.requiresHostnameVerification = requiresHostnameVerification;
        this.revocationCheckingStrategy = revocationCheckingStrategy;
        SSLContextManager sslContextManager = new SSLContextManager(clientCertificateManager, sslContextSupplier, logging);
        this.sslContextSupplier = sslContextManager::getSSLContext;
        this.requiresClientAuth = clientCertificateManager != null;
    }

    private SecurityPlanImpl() {
        this.requiresEncryption = false;
        this.requiresHostnameVerification = false;
        this.revocationCheckingStrategy = RevocationCheckingStrategy.NO_CHECKS;
        this.sslContextSupplier = Futures::completedWithNull;
        this.requiresClientAuth = false;
    }

    @Override
    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    @Override
    public boolean requiresClientAuth() {
        return this.requiresClientAuth;
    }

    @Override
    public CompletionStage<SSLContext> sslContext() {
        return this.sslContextSupplier.get();
    }

    @Override
    public boolean requiresHostnameVerification() {
        return this.requiresHostnameVerification;
    }

    @Override
    public RevocationCheckingStrategy revocationCheckingStrategy() {
        return this.revocationCheckingStrategy;
    }

    private static org.neo4j.driver.internal.bolt.api.ssl.RevocationCheckingStrategy map(RevocationCheckingStrategy revocationCheckingStrategy) {
        return switch (revocationCheckingStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case RevocationCheckingStrategy.NO_CHECKS -> org.neo4j.driver.internal.bolt.api.ssl.RevocationCheckingStrategy.NO_CHECKS;
            case RevocationCheckingStrategy.VERIFY_IF_PRESENT -> org.neo4j.driver.internal.bolt.api.ssl.RevocationCheckingStrategy.VERIFY_IF_PRESENT;
            case RevocationCheckingStrategy.STRICT -> org.neo4j.driver.internal.bolt.api.ssl.RevocationCheckingStrategy.STRICT;
        };
    }
}

