/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ListenerEvent;
import org.neo4j.driver.internal.bolt.api.MetricsListener;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.DevNullPoolMetricsListener;
import org.neo4j.driver.internal.metrics.InternalConnectionPoolMetrics;
import org.neo4j.driver.internal.metrics.TimeRecorderListenerEvent;

final class InternalMetrics
implements Metrics,
MetricsListener {
    private final Map<String, ConnectionPoolMetrics> connectionPoolMetrics;
    private final Clock clock;
    private final Logger log;

    InternalMetrics(Clock clock, Logging logging) {
        Objects.requireNonNull(clock);
        this.connectionPoolMetrics = new ConcurrentHashMap<String, ConnectionPoolMetrics>();
        this.clock = clock;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public void registerPoolMetrics(String poolId, BoltServerAddress serverAddress, IntSupplier inUseSupplier, IntSupplier idleSupplier) {
        this.connectionPoolMetrics.put(poolId, new InternalConnectionPoolMetrics(poolId, serverAddress, inUseSupplier, idleSupplier));
    }

    @Override
    public void removePoolMetrics(String id) {
        this.connectionPoolMetrics.remove(id);
    }

    @Override
    public void beforeCreating(String poolId, ListenerEvent<?> creatingEvent) {
        this.poolMetrics(poolId).beforeCreating(creatingEvent);
    }

    @Override
    public void afterCreated(String poolId, ListenerEvent<?> creatingEvent) {
        this.poolMetrics(poolId).afterCreated(creatingEvent);
    }

    @Override
    public void afterFailedToCreate(String poolId) {
        this.poolMetrics(poolId).afterFailedToCreate();
    }

    @Override
    public void afterClosed(String poolId) {
        this.poolMetrics(poolId).afterClosed();
    }

    @Override
    public void beforeAcquiringOrCreating(String poolId, ListenerEvent<?> acquireEvent) {
        this.poolMetrics(poolId).beforeAcquiringOrCreating(acquireEvent);
    }

    @Override
    public void afterAcquiringOrCreating(String poolId) {
        this.poolMetrics(poolId).afterAcquiringOrCreating();
    }

    @Override
    public void afterAcquiredOrCreated(String poolId, ListenerEvent<?> acquireEvent) {
        this.poolMetrics(poolId).afterAcquiredOrCreated(acquireEvent);
    }

    @Override
    public void afterConnectionCreated(String poolId, ListenerEvent<?> inUseEvent) {
        this.poolMetrics(poolId).acquired(inUseEvent);
    }

    @Override
    public void afterConnectionReleased(String poolId, ListenerEvent<?> inUseEvent) {
        this.poolMetrics(poolId).released(inUseEvent);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate(String poolId) {
        this.poolMetrics(poolId).afterTimedOutToAcquireOrCreate();
    }

    @Override
    public ListenerEvent<?> createListenerEvent() {
        return new TimeRecorderListenerEvent(this.clock);
    }

    @Override
    public Collection<ConnectionPoolMetrics> connectionPoolMetrics() {
        return Collections.unmodifiableCollection(this.connectionPoolMetrics.values());
    }

    public String toString() {
        return String.format("PoolMetrics=%s", this.connectionPoolMetrics);
    }

    private ConnectionPoolMetricsListener poolMetrics(String poolId) {
        InternalConnectionPoolMetrics poolMetrics = (InternalConnectionPoolMetrics)this.connectionPoolMetrics.get(poolId);
        if (poolMetrics == null) {
            this.log.warn(String.format("Failed to find pool metrics with id `%s` in %s.", poolId, this.connectionPoolMetrics), new Object[0]);
            return DevNullPoolMetricsListener.INSTANCE;
        }
        return poolMetrics;
    }
}

