/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.PullMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;
import org.neo4j.driver.internal.value.BooleanValue;

public class PullResponseHandlerImpl
implements ResponseHandler {
    private final PullMessageHandler handler;

    public PullResponseHandlerImpl(PullMessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        boolean hasMore = metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean();
        this.handler.onSummary(new PullSummaryImpl(hasMore, metadata));
    }

    @Override
    public void onFailure(Throwable throwable) {
        this.handler.onError(throwable);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.handler.onRecord(fields);
    }

    public record PullSummaryImpl(boolean hasMore, Map<String, Value> metadata) implements PullSummary
    {
    }
}

