/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl.cluster;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.Rediscovery;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableHandlerImpl;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.bolt.routedimpl.util.FutureUtil;

public class RoutingTableRegistryImpl
implements RoutingTableRegistry {
    private static final Supplier<IllegalStateException> PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER = () -> new IllegalStateException("Pending database name encountered.");
    private final ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers;
    private final Map<Principal, CompletionStage<DatabaseName>> principalToDatabaseNameStage;
    private final RoutingTableHandlerFactory factory;
    private final System.Logger log;
    private final Clock clock;
    private final Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter;
    private final Rediscovery rediscovery;

    public RoutingTableRegistryImpl(Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Rediscovery rediscovery, Clock clock, LoggingProvider logging, long routingTablePurgeDelayMs, Consumer<Set<BoltServerAddress>> addressesToRetainConsumer) {
        this(new ConcurrentHashMap<DatabaseName, RoutingTableHandler>(), new RoutingTableHandlerFactory(connectionProviderGetter, rediscovery, clock, logging, routingTablePurgeDelayMs, addressesToRetainConsumer), clock, connectionProviderGetter, rediscovery, logging);
    }

    RoutingTableRegistryImpl(ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers, RoutingTableHandlerFactory factory, Clock clock, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Rediscovery rediscovery, LoggingProvider logging) {
        Objects.requireNonNull(rediscovery, "rediscovery must not be null");
        this.factory = factory;
        this.routingTableHandlers = routingTableHandlers;
        this.principalToDatabaseNameStage = new HashMap<Principal, CompletionStage<DatabaseName>>();
        this.clock = clock;
        this.connectionProviderGetter = connectionProviderGetter;
        this.rediscovery = rediscovery;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public CompletionStage<RoutingTableHandler> ensureRoutingTable(SecurityPlan securityPlan, CompletableFuture<DatabaseName> databaseNameFuture, AccessMode mode, Set<String> rediscoveryBookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion) {
        return this.ensureDatabaseNameIsCompleted(securityPlan, databaseNameFuture, mode, rediscoveryBookmarks, impersonatedUser, authMapStageSupplier, minVersion).thenCompose(ctxAndHandler -> {
            RoutingTableHandler handler = ctxAndHandler.handler() != null ? ctxAndHandler.handler() : this.getOrCreate(FutureUtil.joinNowOrElseThrow(ctxAndHandler.databaseNameFuture(), PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER));
            return handler.ensureRoutingTable(securityPlan, mode, rediscoveryBookmarks, authMapStageSupplier, minVersion).thenApply(ignored -> handler);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<ConnectionContextAndHandler> ensureDatabaseNameIsCompleted(SecurityPlan securityPlan, CompletableFuture<DatabaseName> databaseNameFutureS, AccessMode mode, Set<String> rediscoveryBookmarks, String impersonatedUser, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion) {
        CompletionStage<ConnectionContextAndHandler> contextAndHandlerStage;
        if (databaseNameFutureS.isDone()) {
            contextAndHandlerStage = CompletableFuture.completedFuture(new ConnectionContextAndHandler(databaseNameFutureS, mode, rediscoveryBookmarks, null));
        } else {
            RoutingTableRegistryImpl routingTableRegistryImpl = this;
            synchronized (routingTableRegistryImpl) {
                if (databaseNameFutureS.isDone()) {
                    contextAndHandlerStage = CompletableFuture.completedFuture(new ConnectionContextAndHandler(databaseNameFutureS, mode, rediscoveryBookmarks, null));
                } else {
                    Principal principal = new Principal(impersonatedUser);
                    CompletionStage<DatabaseName> databaseNameStage = this.principalToDatabaseNameStage.get(principal);
                    AtomicReference handlerRef = new AtomicReference();
                    if (databaseNameStage == null) {
                        CompletableFuture<DatabaseName> databaseNameFuture = new CompletableFuture<DatabaseName>();
                        this.principalToDatabaseNameStage.put(principal, databaseNameFuture);
                        databaseNameStage = databaseNameFuture;
                        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), this.clock, new BoltServerAddress[0]);
                        this.rediscovery.lookupClusterComposition(securityPlan, routingTable, this.connectionProviderGetter, rediscoveryBookmarks, impersonatedUser, authMapStageSupplier, minVersion).thenCompose(compositionLookupResult -> {
                            DatabaseName databaseName = DatabaseNameUtil.database(compositionLookupResult.getClusterComposition().databaseName());
                            RoutingTableHandler handler = this.getOrCreate(databaseName);
                            handlerRef.set(handler);
                            return handler.updateRoutingTable((ClusterCompositionLookupResult)compositionLookupResult).thenApply(ignored -> databaseName);
                        }).whenComplete((databaseName, throwable) -> {
                            RoutingTableRegistryImpl routingTableRegistryImpl = this;
                            synchronized (routingTableRegistryImpl) {
                                this.principalToDatabaseNameStage.remove(principal);
                            }
                        }).whenComplete((databaseName, throwable) -> {
                            if (throwable != null) {
                                databaseNameFuture.completeExceptionally((Throwable)throwable);
                            } else {
                                databaseNameFuture.complete((DatabaseName)databaseName);
                            }
                        });
                    }
                    contextAndHandlerStage = databaseNameStage.thenApply(databaseName -> {
                        RoutingTableRegistryImpl routingTableRegistryImpl = this;
                        synchronized (routingTableRegistryImpl) {
                            databaseNameFutureS.complete((DatabaseName)databaseName);
                        }
                        return new ConnectionContextAndHandler(databaseNameFutureS, mode, rediscoveryBookmarks, (RoutingTableHandler)handlerRef.get());
                    });
                }
            }
        }
        return contextAndHandlerStage;
    }

    @Override
    public Set<BoltServerAddress> allServers() {
        return this.routingTableHandlers.values().stream().flatMap(tableHandler -> tableHandler.servers().stream()).collect(Collectors.toSet());
    }

    @Override
    public void remove(DatabaseName databaseName) {
        this.routingTableHandlers.remove(databaseName);
        this.log.log(System.Logger.Level.DEBUG, "Routing table handler for database '%s' is removed.", databaseName.description());
    }

    @Override
    public void removeAged() {
        this.routingTableHandlers.forEach((databaseName, handler) -> {
            if (handler.isRoutingTableAged()) {
                this.log.log(System.Logger.Level.INFO, "Routing table handler for database '%s' is removed because it has not been used for a long time. Routing table: %s", databaseName.description(), handler.routingTable());
                this.routingTableHandlers.remove(databaseName);
            }
        });
    }

    @Override
    public Optional<RoutingTableHandler> getRoutingTableHandler(DatabaseName databaseName) {
        return Optional.ofNullable((RoutingTableHandler)this.routingTableHandlers.get(databaseName));
    }

    public boolean contains(DatabaseName databaseName) {
        return this.routingTableHandlers.containsKey(databaseName);
    }

    private RoutingTableHandler getOrCreate(DatabaseName databaseName) {
        return this.routingTableHandlers.computeIfAbsent(databaseName, name -> {
            RoutingTableHandler handler = this.factory.newInstance((DatabaseName)name, this);
            this.log.log(System.Logger.Level.DEBUG, "Routing table handler for database '%s' is added.", databaseName.description());
            return handler;
        });
    }

    static class RoutingTableHandlerFactory {
        private final Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter;
        private final Rediscovery rediscovery;
        private final LoggingProvider logging;
        private final Clock clock;
        private final long routingTablePurgeDelayMs;
        private final Consumer<Set<BoltServerAddress>> addressesToRetainConsumer;

        RoutingTableHandlerFactory(Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, Rediscovery rediscovery, Clock clock, LoggingProvider logging, long routingTablePurgeDelayMs, Consumer<Set<BoltServerAddress>> addressesToRetainConsumer) {
            this.connectionProviderGetter = connectionProviderGetter;
            this.rediscovery = rediscovery;
            this.clock = clock;
            this.logging = logging;
            this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
            this.addressesToRetainConsumer = addressesToRetainConsumer;
        }

        RoutingTableHandler newInstance(DatabaseName databaseName, RoutingTableRegistry allTables) {
            ClusterRoutingTable routingTable = new ClusterRoutingTable(databaseName, this.clock, new BoltServerAddress[0]);
            return new RoutingTableHandlerImpl(routingTable, this.rediscovery, this.connectionProviderGetter, allTables, this.logging, this.routingTablePurgeDelayMs, this.addressesToRetainConsumer);
        }
    }

    private record ConnectionContextAndHandler(CompletableFuture<DatabaseName> databaseNameFuture, AccessMode mode, Set<String> rediscoveryBookmarks, RoutingTableHandler handler) {
    }

    private record Principal(String id) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Principal principal = (Principal)o;
            return Objects.equals(this.id, principal.id);
        }
    }
}

