/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.common;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.ValueUnpacker;
import org.neo4j.driver.internal.bolt.basicimpl.packstream.PackInput;
import org.neo4j.driver.internal.bolt.basicimpl.packstream.PackStream;
import org.neo4j.driver.internal.bolt.basicimpl.packstream.PackType;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.internal.value.UnsupportedDateTimeValue;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class CommonValueUnpacker
implements ValueUnpacker {
    public static final byte DATE = 68;
    public static final int DATE_STRUCT_SIZE = 1;
    public static final byte TIME = 84;
    public static final int TIME_STRUCT_SIZE = 2;
    public static final byte LOCAL_TIME = 116;
    public static final int LOCAL_TIME_STRUCT_SIZE = 1;
    public static final byte LOCAL_DATE_TIME = 100;
    public static final int LOCAL_DATE_TIME_STRUCT_SIZE = 2;
    public static final byte DATE_TIME_WITH_ZONE_OFFSET = 70;
    public static final byte DATE_TIME_WITH_ZONE_OFFSET_UTC = 73;
    public static final byte DATE_TIME_WITH_ZONE_ID = 102;
    public static final byte DATE_TIME_WITH_ZONE_ID_UTC = 105;
    public static final int DATE_TIME_STRUCT_SIZE = 3;
    public static final byte DURATION = 69;
    public static final int DURATION_TIME_STRUCT_SIZE = 4;
    public static final byte POINT_2D_STRUCT_TYPE = 88;
    public static final int POINT_2D_STRUCT_SIZE = 3;
    public static final byte POINT_3D_STRUCT_TYPE = 89;
    public static final int POINT_3D_STRUCT_SIZE = 4;
    public static final byte NODE = 78;
    public static final byte RELATIONSHIP = 82;
    public static final byte UNBOUND_RELATIONSHIP = 114;
    public static final byte PATH = 80;
    private static final int NODE_FIELDS = 3;
    private static final int RELATIONSHIP_FIELDS = 5;
    private final boolean dateTimeUtcEnabled;
    protected final PackStream.Unpacker unpacker;

    public CommonValueUnpacker(PackInput input, boolean dateTimeUtcEnabled) {
        this.dateTimeUtcEnabled = dateTimeUtcEnabled;
        this.unpacker = new PackStream.Unpacker(input);
    }

    @Override
    public long unpackStructHeader() throws IOException {
        return this.unpacker.unpackStructHeader();
    }

    @Override
    public int unpackStructSignature() throws IOException {
        return this.unpacker.unpackStructSignature();
    }

    @Override
    public Map<String, Value> unpackMap() throws IOException {
        int size = (int)this.unpacker.unpackMapHeader();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> map = new HashMap<String, Value>(size);
        for (int i = 0; i < size; ++i) {
            String key = this.unpacker.unpackString();
            map.put(key, this.unpack());
        }
        return map;
    }

    @Override
    public Value[] unpackArray() throws IOException {
        int size = (int)this.unpacker.unpackListHeader();
        Value[] values = new Value[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.unpack();
        }
        return values;
    }

    protected Value unpack() throws IOException {
        PackType type = this.unpacker.peekNextType();
        switch (type) {
            case NULL: {
                return Values.value(this.unpacker.unpackNull());
            }
            case BOOLEAN: {
                return Values.value(this.unpacker.unpackBoolean());
            }
            case INTEGER: {
                return Values.value(this.unpacker.unpackLong());
            }
            case FLOAT: {
                return Values.value(this.unpacker.unpackDouble());
            }
            case BYTES: {
                return Values.value(this.unpacker.unpackBytes());
            }
            case STRING: {
                return Values.value(this.unpacker.unpackString());
            }
            case MAP: {
                return new MapValue(this.unpackMap());
            }
            case LIST: {
                int size = (int)this.unpacker.unpackListHeader();
                Value[] vals = new Value[size];
                for (int j = 0; j < size; ++j) {
                    vals[j] = this.unpack();
                }
                return new ListValue(vals);
            }
            case STRUCT: {
                long size = this.unpacker.unpackStructHeader();
                byte structType = this.unpacker.unpackStructSignature();
                return this.unpackStruct(size, structType);
            }
        }
        throw new IOException("Unknown value type: " + type);
    }

    private Value unpackStruct(long size, byte type) throws IOException {
        switch (type) {
            case 68: {
                this.ensureCorrectStructSize(TypeConstructor.DATE, 1, size);
                return this.unpackDate();
            }
            case 84: {
                this.ensureCorrectStructSize(TypeConstructor.TIME, 2, size);
                return this.unpackTime();
            }
            case 116: {
                this.ensureCorrectStructSize(TypeConstructor.LOCAL_TIME, 1, size);
                return this.unpackLocalTime();
            }
            case 100: {
                this.ensureCorrectStructSize(TypeConstructor.LOCAL_DATE_TIME, 2, size);
                return this.unpackLocalDateTime();
            }
            case 70: {
                if (!this.dateTimeUtcEnabled) {
                    this.ensureCorrectStructSize(TypeConstructor.DATE_TIME, 3, size);
                    return this.unpackDateTime(ZoneMode.OFFSET, BaselineMode.LEGACY);
                }
                throw this.instantiateExceptionForUnknownType(type);
            }
            case 73: {
                if (this.dateTimeUtcEnabled) {
                    this.ensureCorrectStructSize(TypeConstructor.DATE_TIME, 3, size);
                    return this.unpackDateTime(ZoneMode.OFFSET, BaselineMode.UTC);
                }
                throw this.instantiateExceptionForUnknownType(type);
            }
            case 102: {
                if (!this.dateTimeUtcEnabled) {
                    this.ensureCorrectStructSize(TypeConstructor.DATE_TIME, 3, size);
                    return this.unpackDateTime(ZoneMode.ZONE_ID, BaselineMode.LEGACY);
                }
                throw this.instantiateExceptionForUnknownType(type);
            }
            case 105: {
                if (this.dateTimeUtcEnabled) {
                    this.ensureCorrectStructSize(TypeConstructor.DATE_TIME, 3, size);
                    return this.unpackDateTime(ZoneMode.ZONE_ID, BaselineMode.UTC);
                }
                throw this.instantiateExceptionForUnknownType(type);
            }
            case 69: {
                this.ensureCorrectStructSize(TypeConstructor.DURATION, 4, size);
                return this.unpackDuration();
            }
            case 88: {
                this.ensureCorrectStructSize(TypeConstructor.POINT, 3, size);
                return this.unpackPoint2D();
            }
            case 89: {
                this.ensureCorrectStructSize(TypeConstructor.POINT, 4, size);
                return this.unpackPoint3D();
            }
            case 78: {
                this.ensureCorrectStructSize(TypeConstructor.NODE, this.getNodeFields(), size);
                InternalNode adapted = this.unpackNode();
                return new NodeValue(adapted);
            }
            case 82: {
                this.ensureCorrectStructSize(TypeConstructor.RELATIONSHIP, this.getRelationshipFields(), size);
                return this.unpackRelationship();
            }
            case 80: {
                this.ensureCorrectStructSize(TypeConstructor.PATH, 3, size);
                return this.unpackPath();
            }
        }
        throw this.instantiateExceptionForUnknownType(type);
    }

    protected Value unpackRelationship() throws IOException {
        long urn = this.unpacker.unpackLong();
        long startUrn = this.unpacker.unpackLong();
        long endUrn = this.unpacker.unpackLong();
        String relType = this.unpacker.unpackString();
        Map<String, Value> props = this.unpackMap();
        InternalRelationship adapted = new InternalRelationship(urn, String.valueOf(urn), startUrn, String.valueOf(startUrn), endUrn, String.valueOf(endUrn), relType, props);
        return new RelationshipValue(adapted);
    }

    protected InternalNode unpackNode() throws IOException {
        long urn = this.unpacker.unpackLong();
        int numLabels = (int)this.unpacker.unpackListHeader();
        ArrayList<String> labels = new ArrayList<String>(numLabels);
        for (int i = 0; i < numLabels; ++i) {
            labels.add(this.unpacker.unpackString());
        }
        int numProps = (int)this.unpacker.unpackMapHeader();
        HashMap<String, Value> props = new HashMap<String, Value>(numProps);
        for (int j = 0; j < numProps; ++j) {
            String key = this.unpacker.unpackString();
            props.put(key, this.unpack());
        }
        return new InternalNode(urn, String.valueOf(urn), labels, props);
    }

    protected Value unpackPath() throws IOException {
        Node prevNode;
        Node[] uniqNodes = new Node[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqNodes.length; ++i) {
            this.ensureCorrectStructSize(TypeConstructor.NODE, this.getNodeFields(), this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("NODE", (byte)78, this.unpacker.unpackStructSignature());
            uniqNodes[i] = this.unpackNode();
        }
        InternalRelationship[] uniqRels = new InternalRelationship[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqRels.length; ++i) {
            this.ensureCorrectStructSize(TypeConstructor.RELATIONSHIP, 3, this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("UNBOUND_RELATIONSHIP", (byte)114, this.unpacker.unpackStructSignature());
            long id = this.unpacker.unpackLong();
            String relType = this.unpacker.unpackString();
            Map<String, Value> props = this.unpackMap();
            uniqRels[i] = new InternalRelationship(id, String.valueOf(id), -1L, String.valueOf(-1), -1L, String.valueOf(-1), relType, props);
        }
        int length = (int)this.unpacker.unpackListHeader();
        Path.Segment[] segments = new Path.Segment[length / 2];
        Node[] nodes = new Node[segments.length + 1];
        Relationship[] rels = new Relationship[segments.length];
        nodes[0] = prevNode = uniqNodes[0];
        for (int i = 0; i < segments.length; ++i) {
            InternalRelationship rel;
            int relIdx = (int)this.unpacker.unpackLong();
            Node nextNode = uniqNodes[(int)this.unpacker.unpackLong()];
            if (relIdx < 0) {
                rel = uniqRels[-relIdx - 1];
                rel.setStartAndEnd(nextNode.id(), String.valueOf(nextNode.id()), prevNode.id(), String.valueOf(prevNode.id()));
            } else {
                rel = uniqRels[relIdx - 1];
                rel.setStartAndEnd(prevNode.id(), String.valueOf(prevNode.id()), nextNode.id(), String.valueOf(nextNode.id()));
            }
            nodes[i + 1] = nextNode;
            rels[i] = rel;
            segments[i] = new InternalPath.SelfContainedSegment(prevNode, rel, nextNode);
            prevNode = nextNode;
        }
        return new PathValue(new InternalPath(Arrays.asList(segments), Arrays.asList(nodes), Arrays.asList(rels)));
    }

    protected final void ensureCorrectStructSize(TypeConstructor typeConstructor, int expected, long actual) {
        if ((long)expected != actual) {
            String structName = typeConstructor.toString();
            String message = String.format("Invalid message received, serialized %s structures should have %d fields, received %s structure has %d fields.", structName, expected, structName, actual);
            throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
        }
    }

    protected void ensureCorrectStructSignature(String structName, byte expected, byte actual) {
        if (expected != actual) {
            String message = String.format("Invalid message received, expected a `%s`, signature 0x%s. Received signature was 0x%s.", structName, Integer.toHexString(expected), Integer.toHexString(actual));
            throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
        }
    }

    private Value unpackDate() throws IOException {
        long epochDay = this.unpacker.unpackLong();
        return Values.value(LocalDate.ofEpochDay(epochDay));
    }

    private Value unpackTime() throws IOException {
        long nanoOfDayLocal = this.unpacker.unpackLong();
        int offsetSeconds = Math.toIntExact(this.unpacker.unpackLong());
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDayLocal);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSeconds);
        return Values.value(OffsetTime.of(localTime, offset));
    }

    private Value unpackLocalTime() throws IOException {
        long nanoOfDayLocal = this.unpacker.unpackLong();
        return Values.value(LocalTime.ofNanoOfDay(nanoOfDayLocal));
    }

    private Value unpackLocalDateTime() throws IOException {
        long epochSecondUtc = this.unpacker.unpackLong();
        int nano = Math.toIntExact(this.unpacker.unpackLong());
        return Values.value(LocalDateTime.ofEpochSecond(epochSecondUtc, nano, ZoneOffset.UTC));
    }

    private Value unpackDateTime(ZoneMode unpackOffset, BaselineMode useUtcBaseline) throws IOException {
        ZoneId zoneId;
        Supplier<ZoneId> zoneIdSupplier;
        long epochSecondLocal = this.unpacker.unpackLong();
        int nano = Math.toIntExact(this.unpacker.unpackLong());
        if (unpackOffset == ZoneMode.OFFSET) {
            int offsetSeconds = Math.toIntExact(this.unpacker.unpackLong());
            zoneIdSupplier = () -> ZoneOffset.ofTotalSeconds(offsetSeconds);
        } else {
            String zoneIdString = this.unpacker.unpackString();
            zoneIdSupplier = () -> ZoneId.of(zoneIdString);
        }
        try {
            zoneId = zoneIdSupplier.get();
        }
        catch (DateTimeException e) {
            return new UnsupportedDateTimeValue(e);
        }
        return useUtcBaseline == BaselineMode.UTC ? Values.value(this.newZonedDateTimeUsingUtcBaseline(epochSecondLocal, nano, zoneId)) : Values.value(CommonValueUnpacker.newZonedDateTime(epochSecondLocal, nano, zoneId));
    }

    private Value unpackDuration() throws IOException {
        long months = this.unpacker.unpackLong();
        long days = this.unpacker.unpackLong();
        long seconds = this.unpacker.unpackLong();
        int nanoseconds = Math.toIntExact(this.unpacker.unpackLong());
        return Values.isoDuration(months, days, seconds, nanoseconds);
    }

    private Value unpackPoint2D() throws IOException {
        int srid = Math.toIntExact(this.unpacker.unpackLong());
        double x = this.unpacker.unpackDouble();
        double y = this.unpacker.unpackDouble();
        return Values.point(srid, x, y);
    }

    private Value unpackPoint3D() throws IOException {
        int srid = Math.toIntExact(this.unpacker.unpackLong());
        double x = this.unpacker.unpackDouble();
        double y = this.unpacker.unpackDouble();
        double z = this.unpacker.unpackDouble();
        return Values.point(srid, x, y, z);
    }

    private static ZonedDateTime newZonedDateTime(long epochSecondLocal, long nano, ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond(epochSecondLocal, nano);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    private ZonedDateTime newZonedDateTimeUsingUtcBaseline(long epochSecondLocal, int nano, ZoneId zoneId) {
        Instant instant = Instant.ofEpochSecond(epochSecondLocal, nano);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    private ProtocolException instantiateExceptionForUnknownType(byte type) {
        return new ProtocolException("Unknown struct type: " + type);
    }

    protected int getNodeFields() {
        return 3;
    }

    protected int getRelationshipFields() {
        return 5;
    }

    private static enum ZoneMode {
        OFFSET,
        ZONE_ID;

    }

    private static enum BaselineMode {
        UTC,
        LEGACY;

    }
}

