/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.summary.BeginSummary;
import org.neo4j.driver.internal.bolt.api.summary.CommitSummary;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogoffSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogonSummary;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.ResetSummary;
import org.neo4j.driver.internal.bolt.api.summary.RollbackSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.api.summary.TelemetrySummary;

public final class BasicResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Summaries> summariesFuture = new CompletableFuture();
    private final List<Value[]> valuesList = new ArrayList<Value[]>();
    private BeginSummary beginSummary;
    private RunSummary runSummary;
    private PullSummary pullSummary;
    private DiscardSummary discardSummary;
    private CommitSummary commitSummary;
    private RollbackSummary rollbackSummary;
    private ResetSummary resetSummary;
    private RouteSummary routeSummary;
    private LogoffSummary logoffSummary;
    private LogonSummary logonSummary;
    private TelemetrySummary telemetrySummary;
    private int ignored;
    private Throwable error;

    public CompletionStage<Summaries> summaries() {
        return this.summariesFuture;
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (this.error == null) {
            this.error = throwable;
        } else if (this.error instanceof Neo4jException && !(throwable instanceof Neo4jException)) {
            throwable.addSuppressed(this.error);
            this.error = throwable;
        } else {
            this.error.addSuppressed(throwable);
        }
    }

    @Override
    public void onBeginSummary(BeginSummary summary) {
        this.beginSummary = summary;
    }

    @Override
    public void onRunSummary(RunSummary summary) {
        this.runSummary = summary;
    }

    @Override
    public void onRecord(Value[] fields) {
        this.valuesList.add(fields);
    }

    @Override
    public void onPullSummary(PullSummary summary) {
        this.pullSummary = summary;
    }

    @Override
    public void onDiscardSummary(DiscardSummary summary) {
        this.discardSummary = summary;
    }

    @Override
    public void onCommitSummary(CommitSummary summary) {
        this.commitSummary = summary;
    }

    @Override
    public void onRollbackSummary(RollbackSummary summary) {
        this.rollbackSummary = summary;
    }

    @Override
    public void onResetSummary(ResetSummary summary) {
        this.resetSummary = summary;
    }

    @Override
    public void onRouteSummary(RouteSummary summary) {
        this.routeSummary = summary;
    }

    @Override
    public void onLogoffSummary(LogoffSummary summary) {
        this.logoffSummary = summary;
    }

    @Override
    public void onLogonSummary(LogonSummary summary) {
        this.logonSummary = summary;
    }

    @Override
    public void onTelemetrySummary(TelemetrySummary summary) {
        this.telemetrySummary = summary;
    }

    @Override
    public void onIgnored() {
        ++this.ignored;
    }

    @Override
    public void onComplete() {
        if (this.error != null) {
            this.summariesFuture.completeExceptionally(this.error);
        } else {
            this.summariesFuture.complete(new Summaries(this.beginSummary, this.runSummary, this.valuesList, this.pullSummary, this.discardSummary, this.commitSummary, this.rollbackSummary, this.resetSummary, this.routeSummary, this.logoffSummary, this.logonSummary, this.telemetrySummary, this.ignored));
        }
    }

    public record Summaries(BeginSummary beginSummary, RunSummary runSummary, List<Value[]> valuesList, PullSummary pullSummary, DiscardSummary discardSummary, CommitSummary commitSummary, RollbackSummary rollbackSummary, ResetSummary resetSummary, RouteSummary routeSummary, LogoffSummary logoffSummary, LogonSummary logonSummary, TelemetrySummary telemetrySummary, int ignored) {
    }
}

