/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.LockUtil;

public class ClusterRoutingTable
implements RoutingTable {
    private static final int MIN_ROUTERS = 1;
    private final ReadWriteLock tableLock = new ReentrantReadWriteLock();
    private final DatabaseName databaseName;
    private final Clock clock;
    private final Set<BoltServerAddress> disused = new HashSet<BoltServerAddress>();
    private long expirationTimestamp;
    private boolean preferInitialRouter = true;
    private List<BoltServerAddress> readers = Collections.emptyList();
    private List<BoltServerAddress> writers = Collections.emptyList();
    private List<BoltServerAddress> routers = Collections.emptyList();

    public ClusterRoutingTable(DatabaseName ofDatabase, Clock clock, BoltServerAddress ... routingAddresses) {
        this(ofDatabase, clock);
        this.routers = Collections.unmodifiableList(Arrays.asList(routingAddresses));
    }

    private ClusterRoutingTable(DatabaseName ofDatabase, Clock clock) {
        this.databaseName = ofDatabase;
        this.clock = clock;
        this.expirationTimestamp = clock.millis() - 1L;
    }

    @Override
    public boolean isStaleFor(AccessMode mode) {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.expirationTimestamp < this.clock.millis() || this.routers.size() < 1 || mode == AccessMode.READ && this.readers.size() == 0 || mode == AccessMode.WRITE && this.writers.size() == 0);
    }

    @Override
    public boolean hasBeenStaleFor(long extraTime) {
        long totalTime = LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.expirationTimestamp) + extraTime;
        if (totalTime < 0L) {
            totalTime = Long.MAX_VALUE;
        }
        return totalTime < this.clock.millis();
    }

    @Override
    public void update(ClusterComposition cluster) {
        LockUtil.executeWithLock(this.tableLock.writeLock(), () -> {
            this.expirationTimestamp = cluster.expirationTimestamp();
            this.readers = this.newWithReusedAddresses(this.readers, this.disused, cluster.readers());
            this.writers = this.newWithReusedAddresses(this.writers, this.disused, cluster.writers());
            this.routers = this.newWithReusedAddresses(this.routers, this.disused, cluster.routers());
            this.disused.clear();
            this.preferInitialRouter = !cluster.hasWriters();
        });
    }

    @Override
    public void forget(BoltServerAddress address) {
        LockUtil.executeWithLock(this.tableLock.writeLock(), () -> {
            this.routers = this.newWithoutAddressIfPresent(this.routers, address);
            this.readers = this.newWithoutAddressIfPresent(this.readers, address);
            this.writers = this.newWithoutAddressIfPresent(this.writers, address);
            this.disused.add(address);
        });
    }

    @Override
    public List<BoltServerAddress> readers() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.readers);
    }

    @Override
    public List<BoltServerAddress> writers() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.writers);
    }

    @Override
    public List<BoltServerAddress> routers() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.routers);
    }

    @Override
    public Set<BoltServerAddress> servers() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> {
            HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
            servers.addAll(this.readers);
            servers.addAll(this.writers);
            servers.addAll(this.routers);
            servers.addAll(this.disused);
            return servers;
        });
    }

    @Override
    public DatabaseName database() {
        return this.databaseName;
    }

    @Override
    public void forgetWriter(BoltServerAddress toRemove) {
        LockUtil.executeWithLock(this.tableLock.writeLock(), () -> {
            this.writers = this.newWithoutAddressIfPresent(this.writers, toRemove);
            this.disused.add(toRemove);
        });
    }

    @Override
    public void replaceRouterIfPresent(BoltServerAddress oldRouter, BoltServerAddress newRouter) {
        LockUtil.executeWithLock(this.tableLock.writeLock(), () -> {
            this.routers = this.newWithAddressReplacedIfPresent(this.routers, oldRouter, newRouter);
            return this.routers;
        });
    }

    @Override
    public boolean preferInitialRouter() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.preferInitialRouter);
    }

    @Override
    public long expirationTimestamp() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> this.expirationTimestamp);
    }

    public String toString() {
        return LockUtil.executeWithLock(this.tableLock.readLock(), () -> String.format("Ttl %s, currentTime %s, routers %s, writers %s, readers %s, database '%s'", this.expirationTimestamp, this.clock.millis(), this.routers, this.writers, this.readers, this.databaseName.description()));
    }

    private List<BoltServerAddress> newWithoutAddressIfPresent(List<BoltServerAddress> addresses, BoltServerAddress addressToSkip) {
        ArrayList<BoltServerAddress> newList = new ArrayList<BoltServerAddress>(addresses.size());
        for (BoltServerAddress address : addresses) {
            if (address.equals(addressToSkip)) continue;
            newList.add(address);
        }
        return Collections.unmodifiableList(newList);
    }

    private List<BoltServerAddress> newWithAddressReplacedIfPresent(List<BoltServerAddress> addresses, BoltServerAddress oldAddress, BoltServerAddress newAddress) {
        ArrayList<BoltServerAddress> newList = new ArrayList<BoltServerAddress>(addresses.size());
        for (BoltServerAddress address : addresses) {
            newList.add(address.equals(oldAddress) ? newAddress : address);
        }
        return Collections.unmodifiableList(newList);
    }

    private List<BoltServerAddress> newWithReusedAddresses(List<BoltServerAddress> currentAddresses, Set<BoltServerAddress> disusedAddresses, Set<BoltServerAddress> newAddresses) {
        List newList = Stream.concat(currentAddresses.stream(), disusedAddresses.stream()).filter(address -> newAddresses.remove(this.toBoltServerAddress((BoltServerAddress)address))).collect(Collectors.toCollection(() -> new ArrayList(newAddresses.size())));
        newList.addAll(newAddresses);
        return Collections.unmodifiableList(newList);
    }

    private BoltServerAddress toBoltServerAddress(BoltServerAddress address) {
        return BoltServerAddress.class.equals(address.getClass()) ? address : new BoltServerAddress(address.host(), address.port());
    }
}

