/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

abstract class AbstractReactiveTransaction {
    protected final UnmanagedTransaction tx;

    protected AbstractReactiveTransaction(UnmanagedTransaction tx) {
        this.tx = tx;
    }

    <T> Publisher<T> doCommit() {
        return RxUtils.createEmptyPublisher(this.tx::commitAsync);
    }

    <T> Publisher<T> doRollback() {
        return RxUtils.createEmptyPublisher(this.tx::rollbackAsync);
    }

    Publisher<Void> doClose() {
        return this.close(false);
    }

    Publisher<Boolean> doIsOpen() {
        return Mono.just((Object)this.tx.isOpen());
    }

    Publisher<Void> close(boolean commit) {
        return RxUtils.createEmptyPublisher(() -> this.tx.closeAsync(commit));
    }
}

