/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class SessionPullResponseCompletionListener
implements PullResponseCompletionListener {
    private final BookmarksHolder bookmarksHolder;
    private final Connection connection;

    public SessionPullResponseCompletionListener(Connection connection, BookmarksHolder bookmarksHolder) {
        this.connection = Objects.requireNonNull(connection);
        this.bookmarksHolder = Objects.requireNonNull(bookmarksHolder);
    }

    @Override
    public void afterSuccess(Map<String, Value> metadata) {
        this.releaseConnection();
        this.bookmarksHolder.setBookmark(MetadataExtractor.extractBookmarks(metadata));
    }

    @Override
    public void afterFailure(Throwable error) {
        if (error instanceof AuthorizationExpiredException) {
            this.connection.terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
        } else if (error instanceof ConnectionReadTimeoutException) {
            this.connection.terminateAndRelease(error.getMessage());
        } else {
            this.releaseConnection();
        }
    }

    private void releaseConnection() {
        this.connection.release();
    }
}

