/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class HelloResponseHandler
implements ResponseHandler {
    private static final String CONNECTION_ID_METADATA_KEY = "connection_id";
    public static final String CONFIGURATION_HINTS_KEY = "hints";
    public static final String CONNECTION_RECEIVE_TIMEOUT_SECONDS_KEY = "connection.recv_timeout_seconds";
    private final ChannelPromise connectionInitializedPromise;
    private final Channel channel;

    public HelloResponseHandler(ChannelPromise connectionInitializedPromise) {
        this.connectionInitializedPromise = connectionInitializedPromise;
        this.channel = connectionInitializedPromise.channel();
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            String serverAgent = MetadataExtractor.extractServer(metadata).asString();
            ChannelAttributes.setServerAgent(this.channel, serverAgent);
            String connectionId = HelloResponseHandler.extractConnectionId(metadata);
            ChannelAttributes.setConnectionId(this.channel, connectionId);
            this.processConfigurationHints(metadata);
            this.connectionInitializedPromise.setSuccess();
        }
        catch (Throwable error) {
            this.onFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.connectionInitializedPromise.setFailure(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private static String extractConnectionId(Map<String, Value> metadata) {
        Value value = metadata.get(CONNECTION_ID_METADATA_KEY);
        if (value == null || value.isNull()) {
            throw new IllegalStateException("Unable to extract connection_id from a response to HELLO message. Received metadata: " + metadata);
        }
        return value.asString();
    }

    private void processConfigurationHints(Map<String, Value> metadata) {
        Value configurationHints = metadata.get(CONFIGURATION_HINTS_KEY);
        if (configurationHints != null) {
            HelloResponseHandler.getFromSupplierOrEmptyOnException(() -> configurationHints.get(CONNECTION_RECEIVE_TIMEOUT_SECONDS_KEY).asLong()).ifPresent(timeout -> ChannelAttributes.setConnectionReadTimeout(this.channel, timeout));
        }
    }

    private static <T> Optional<T> getFromSupplierOrEmptyOnException(Supplier<T> supplier) {
        try {
            return Optional.of(supplier.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

