/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.summary.ResultSummary;

public class BasicPullResponseHandler
implements PullResponseHandler {
    private final Query query;
    protected final RunResponseHandler runResponseHandler;
    protected final MetadataExtractor metadataExtractor;
    protected final Connection connection;
    private final PullResponseCompletionListener completionListener;
    private State state;
    private long toRequest;
    private BiConsumer<Record, Throwable> recordConsumer = null;
    private BiConsumer<ResultSummary, Throwable> summaryConsumer = null;

    public BasicPullResponseHandler(Query query, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor, PullResponseCompletionListener completionListener) {
        this.query = Objects.requireNonNull(query);
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.metadataExtractor = Objects.requireNonNull(metadataExtractor);
        this.connection = Objects.requireNonNull(connection);
        this.completionListener = Objects.requireNonNull(completionListener);
        this.state = State.READY_STATE;
    }

    @Override
    public synchronized void onSuccess(Map<String, Value> metadata) {
        this.assertRecordAndSummaryConsumerInstalled();
        this.state.onSuccess(this, metadata);
    }

    @Override
    public synchronized void onFailure(Throwable error) {
        this.assertRecordAndSummaryConsumerInstalled();
        this.state.onFailure(this, error);
    }

    @Override
    public synchronized void onRecord(Value[] fields) {
        this.assertRecordAndSummaryConsumerInstalled();
        this.state.onRecord(this, fields);
    }

    public synchronized void request(long size) {
        this.assertRecordAndSummaryConsumerInstalled();
        this.state.request(this, size);
    }

    public synchronized void cancel() {
        this.assertRecordAndSummaryConsumerInstalled();
        this.state.cancel(this);
    }

    protected void completeWithFailure(Throwable error) {
        this.completionListener.afterFailure(error);
        this.complete(this.extractResultSummary(Collections.emptyMap()), error);
    }

    protected void completeWithSuccess(Map<String, Value> metadata) {
        ResultSummary summary;
        this.completionListener.afterSuccess(metadata);
        Neo4jException exception = null;
        try {
            summary = this.extractResultSummary(metadata);
        }
        catch (Neo4jException e) {
            summary = this.extractResultSummary(Collections.emptyMap());
            exception = e;
        }
        this.complete(summary, exception);
    }

    protected void successHasMore() {
        if (this.toRequest > 0L || this.toRequest == -1L) {
            this.request(this.toRequest);
            this.toRequest = 0L;
        }
        this.summaryConsumer.accept(null, null);
    }

    protected void handleRecord(Value[] fields) {
        InternalRecord record = new InternalRecord(this.runResponseHandler.queryKeys(), fields);
        this.recordConsumer.accept(record, null);
    }

    protected void writePull(long n) {
        this.connection.writeAndFlush(new PullMessage(n, this.runResponseHandler.queryId()), this);
    }

    protected void discardAll() {
        this.connection.writeAndFlush(DiscardMessage.newDiscardAllMessage(this.runResponseHandler.queryId()), this);
    }

    @Override
    public synchronized void installSummaryConsumer(BiConsumer<ResultSummary, Throwable> summaryConsumer) {
        if (this.summaryConsumer != null) {
            throw new IllegalStateException("Summary consumer already installed.");
        }
        this.summaryConsumer = summaryConsumer;
    }

    @Override
    public synchronized void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        if (this.recordConsumer != null) {
            throw new IllegalStateException("Record consumer already installed.");
        }
        this.recordConsumer = recordConsumer;
    }

    protected boolean isDone() {
        return this.state.equals((Object)State.SUCCEEDED_STATE) || this.state.equals((Object)State.FAILURE_STATE);
    }

    private ResultSummary extractResultSummary(Map<String, Value> metadata) {
        long resultAvailableAfter = this.runResponseHandler.resultAvailableAfter();
        return this.metadataExtractor.extractSummary(this.query, this.connection, resultAvailableAfter, metadata);
    }

    private void addToRequest(long toAdd) {
        if (this.toRequest == -1L) {
            return;
        }
        if (toAdd == -1L) {
            this.toRequest = -1L;
            return;
        }
        if (toAdd <= 0L) {
            throw new IllegalArgumentException("Cannot request record amount that is less than or equal to 0. Request amount: " + toAdd);
        }
        this.toRequest += toAdd;
        if (this.toRequest <= 0L) {
            this.toRequest = Long.MAX_VALUE;
        }
    }

    private void assertRecordAndSummaryConsumerInstalled() {
        if (this.isDone()) {
            return;
        }
        if (this.recordConsumer == null || this.summaryConsumer == null) {
            throw new IllegalStateException(String.format("Access record stream without record consumer and/or summary consumer. Record consumer=%s, Summary consumer=%s", this.recordConsumer, this.summaryConsumer));
        }
    }

    private void complete(ResultSummary summary, Throwable error) {
        this.summaryConsumer.accept(summary, error);
        this.recordConsumer.accept(null, error);
        this.dispose();
    }

    private void dispose() {
        this.recordConsumer = null;
        this.summaryConsumer = null;
    }

    protected State state() {
        return this.state;
    }

    protected void state(State state) {
        this.state = state;
    }

    static enum State {
        READY_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                context.state(SUCCEEDED_STATE);
                context.completeWithSuccess(metadata);
            }

            @Override
            void onFailure(BasicPullResponseHandler context, Throwable error) {
                context.state(FAILURE_STATE);
                context.completeWithFailure(error);
            }

            @Override
            void onRecord(BasicPullResponseHandler context, Value[] fields) {
                context.state(READY_STATE);
            }

            @Override
            void request(BasicPullResponseHandler context, long n) {
                context.state(STREAMING_STATE);
                context.writePull(n);
            }

            @Override
            void cancel(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
                context.discardAll();
            }
        }
        ,
        STREAMING_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                if (metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean()) {
                    context.state(READY_STATE);
                    context.successHasMore();
                } else {
                    context.state(SUCCEEDED_STATE);
                    context.completeWithSuccess(metadata);
                }
            }

            @Override
            void onFailure(BasicPullResponseHandler context, Throwable error) {
                context.state(FAILURE_STATE);
                context.completeWithFailure(error);
            }

            @Override
            void onRecord(BasicPullResponseHandler context, Value[] fields) {
                context.state(STREAMING_STATE);
                context.handleRecord(fields);
            }

            @Override
            void request(BasicPullResponseHandler context, long n) {
                context.state(STREAMING_STATE);
                context.addToRequest(n);
            }

            @Override
            void cancel(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
            }
        }
        ,
        CANCELLED_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                if (metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean()) {
                    context.state(CANCELLED_STATE);
                    context.discardAll();
                } else {
                    context.state(SUCCEEDED_STATE);
                    context.completeWithSuccess(metadata);
                }
            }

            @Override
            void onFailure(BasicPullResponseHandler context, Throwable error) {
                context.state(FAILURE_STATE);
                context.completeWithFailure(error);
            }

            @Override
            void onRecord(BasicPullResponseHandler context, Value[] fields) {
                context.state(CANCELLED_STATE);
            }

            @Override
            void request(BasicPullResponseHandler context, long n) {
                context.state(CANCELLED_STATE);
            }

            @Override
            void cancel(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
            }
        }
        ,
        SUCCEEDED_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                context.state(SUCCEEDED_STATE);
                context.completeWithSuccess(metadata);
            }

            @Override
            void onFailure(BasicPullResponseHandler context, Throwable error) {
                context.state(FAILURE_STATE);
                context.completeWithFailure(error);
            }

            @Override
            void onRecord(BasicPullResponseHandler context, Value[] fields) {
                context.state(SUCCEEDED_STATE);
            }

            @Override
            void request(BasicPullResponseHandler context, long n) {
                context.state(SUCCEEDED_STATE);
            }

            @Override
            void cancel(BasicPullResponseHandler context) {
                context.state(SUCCEEDED_STATE);
            }
        }
        ,
        FAILURE_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                context.state(SUCCEEDED_STATE);
                context.completeWithSuccess(metadata);
            }

            @Override
            void onFailure(BasicPullResponseHandler context, Throwable error) {
                context.state(FAILURE_STATE);
                context.completeWithFailure(error);
            }

            @Override
            void onRecord(BasicPullResponseHandler context, Value[] fields) {
                context.state(FAILURE_STATE);
            }

            @Override
            void request(BasicPullResponseHandler context, long n) {
                context.state(FAILURE_STATE);
            }

            @Override
            void cancel(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }
        };


        abstract void onSuccess(BasicPullResponseHandler var1, Map<String, Value> var2);

        abstract void onFailure(BasicPullResponseHandler var1, Throwable var2);

        abstract void onRecord(BasicPullResponseHandler var1, Value[] var2);

        abstract void request(BasicPullResponseHandler var1, long var2);

        abstract void cancel(BasicPullResponseHandler var1);
    }
}

