/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Comparator;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxMergeOrdered;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ParallelFlux;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;

final class ParallelMergeOrdered<T>
extends Flux<T>
implements Scannable {
    final ParallelFlux<? extends T> source;
    final int prefetch;
    final Comparator<? super T> valueComparator;

    ParallelMergeOrdered(ParallelFlux<? extends T> source, int prefetch, Comparator<? super T> valueComparator) {
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.source = source;
        this.prefetch = prefetch;
        this.valueComparator = valueComparator;
    }

    @Override
    public int getPrefetch() {
        return this.prefetch;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.prefetch;
        }
        return null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxMergeOrdered.MergeOrderedMainProducer<? super T> main = new FluxMergeOrdered.MergeOrderedMainProducer<T>(actual, this.valueComparator, this.prefetch, this.source.parallelism());
        actual.onSubscribe(main);
        this.source.subscribe(main.subscribers);
    }
}

