/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SourceProducer;

final class MonoSingleCallable<T>
extends Mono<T>
implements Callable<T>,
Fuseable,
SourceProducer<T> {
    final Callable<? extends T> callable;

    MonoSingleCallable(Callable<? extends T> source) {
        this.callable = source;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoInnerProducerBase<T> sds = new Operators.MonoInnerProducerBase<T>(actual);
        actual.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            T t = this.callable.call();
            if (t == null) {
                actual.onError(new NoSuchElementException("Source was empty"));
            } else {
                sds.complete(t);
            }
        }
        catch (Throwable e) {
            actual.onError(Operators.onOperatorError(e, actual.currentContext()));
        }
    }

    @Override
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    public T block(Duration m) {
        T v;
        try {
            v = this.callable.call();
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
        if (v == null) {
            throw new NoSuchElementException("Source was empty");
        }
        return v;
    }

    @Override
    public T call() throws Exception {
        T v = this.callable.call();
        if (v == null) {
            throw new NoSuchElementException("Source was empty");
        }
        return v;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

