/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.CodecException;
import org.neo4j.driver.internal.util.ErrorUtil;

public class ChannelErrorHandler
extends ChannelInboundHandlerAdapter {
    private final Logging logging;
    private InboundMessageDispatcher messageDispatcher;
    private Logger log;
    private boolean failed;

    public ChannelErrorHandler(Logging logging) {
        this.logging = logging;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(ctx.channel()));
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.log = null;
        this.failed = false;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.debug("Channel is inactive", new Object[0]);
        if (!this.failed) {
            String terminationReason = ChannelAttributes.terminationReason(ctx.channel());
            ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError(terminationReason);
            this.fail(ctx, error);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.log.warn("Another fatal error occurred in the pipeline", error);
        } else {
            this.failed = true;
            this.log.warn("Fatal error occurred in the pipeline", error);
            this.fail(ctx, error);
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        Throwable cause = ChannelErrorHandler.transformError(error);
        this.messageDispatcher.handleChannelError(cause);
        this.log.debug("Closing channel because of a failure '%s'", error);
        ctx.close();
    }

    private static Throwable transformError(Throwable error) {
        if (error instanceof CodecException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof IOException) {
            return new ServiceUnavailableException("Connection to the database failed", error);
        }
        return error;
    }
}

