/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.request.MessageWithMetadata;

public class HelloMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 1;
    private static final String USER_AGENT_METADATA_KEY = "user_agent";

    public HelloMessage(String userAgent, Map<String, Value> authToken) {
        super(HelloMessage.buildMetadata(userAgent, authToken));
    }

    @Override
    public byte signature() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.metadata());
    }

    public String toString() {
        HashMap<String, Value> metadataCopy = new HashMap<String, Value>(this.metadata());
        metadataCopy.replace("credentials", Values.value("******"));
        return "HELLO " + metadataCopy;
    }

    private static Map<String, Value> buildMetadata(String userAgent, Map<String, Value> authToken) {
        HashMap<String, Value> result = new HashMap<String, Value>(authToken);
        result.put(USER_AGENT_METADATA_KEY, Values.value(userAgent));
        return result;
    }
}

