/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v3;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cursor.AsyncStatementResultCursorOnlyFactory;
import org.neo4j.driver.internal.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class BoltProtocolV3
implements BoltProtocol {
    public static final int VERSION = 3;
    public static final BoltProtocol INSTANCE = new BoltProtocolV3();
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_first", "t_last");

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV3();
    }

    @Override
    public void initializeChannel(String userAgent, Map<String, Value> authToken, ChannelPromise channelInitializedPromise) {
        Channel channel = channelInitializedPromise.channel();
        HelloMessage message = new HelloMessage(userAgent, authToken);
        HelloResponseHandler handler = new HelloResponseHandler(channelInitializedPromise);
        ChannelAttributes.messageDispatcher(channel).enqueue(handler);
        channel.writeAndFlush(message, channel.voidPromise());
    }

    @Override
    public void prepareToCloseChannel(Channel channel) {
        GoodbyeMessage message = GoodbyeMessage.GOODBYE;
        ChannelAttributes.messageDispatcher(channel).enqueue(NoOpResponseHandler.INSTANCE);
        channel.writeAndFlush(message, channel.voidPromise());
    }

    @Override
    public CompletionStage<Void> beginTransaction(Connection connection, InternalBookmark bookmark, TransactionConfig config) {
        try {
            this.verifyDatabaseNameBeforeTransaction(connection.databaseName());
        }
        catch (Exception error) {
            return Futures.failedFuture(error);
        }
        BeginMessage beginMessage = new BeginMessage(bookmark, config, connection.databaseName(), connection.mode());
        if (bookmark.isEmpty()) {
            connection.write(beginMessage, NoOpResponseHandler.INSTANCE);
            return Futures.completedWithNull();
        }
        CompletableFuture<Void> beginTxFuture = new CompletableFuture<Void>();
        connection.writeAndFlush(beginMessage, new BeginTxResponseHandler(beginTxFuture));
        return beginTxFuture;
    }

    @Override
    public CompletionStage<InternalBookmark> commitTransaction(Connection connection) {
        CompletableFuture<InternalBookmark> commitFuture = new CompletableFuture<InternalBookmark>();
        connection.writeAndFlush(CommitMessage.COMMIT, new CommitTxResponseHandler(commitFuture));
        return commitFuture;
    }

    @Override
    public CompletionStage<Void> rollbackTransaction(Connection connection) {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        connection.writeAndFlush(RollbackMessage.ROLLBACK, new RollbackTxResponseHandler(rollbackFuture));
        return rollbackFuture;
    }

    @Override
    public StatementResultCursorFactory runInAutoCommitTransaction(Connection connection, Statement statement, BookmarkHolder bookmarkHolder, TransactionConfig config, boolean waitForRunResponse, long fetchSize) {
        this.verifyDatabaseNameBeforeTransaction(connection.databaseName());
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(statement, config, connection.databaseName(), connection.mode(), bookmarkHolder.getBookmark());
        return this.buildResultCursorFactory(connection, statement, bookmarkHolder, null, runMessage, waitForRunResponse, fetchSize);
    }

    @Override
    public StatementResultCursorFactory runInExplicitTransaction(Connection connection, Statement statement, ExplicitTransaction tx, boolean waitForRunResponse, long fetchSize) {
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.explicitTxRunMessage(statement);
        return this.buildResultCursorFactory(connection, statement, BookmarkHolder.NO_OP, tx, runMessage, waitForRunResponse, fetchSize);
    }

    protected StatementResultCursorFactory buildResultCursorFactory(Connection connection, Statement statement, BookmarkHolder bookmarkHolder, ExplicitTransaction tx, RunWithMetadataMessage runMessage, boolean waitForRunResponse, long ignored) {
        RunResponseHandler runHandler = new RunResponseHandler(METADATA_EXTRACTOR);
        PullAllResponseHandler pullHandler = PullHandlers.newBoltV3PullAllHandler(statement, runHandler, connection, bookmarkHolder, tx);
        return new AsyncStatementResultCursorOnlyFactory(connection, runMessage, runHandler, pullHandler, waitForRunResponse);
    }

    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
        MultiDatabaseUtil.assertEmptyDatabaseName(databaseName, this.version());
    }

    @Override
    public int version() {
        return 3;
    }
}

