/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.cursor.AsyncStatementResultCursor;
import org.neo4j.driver.internal.cursor.AsyncStatementResultCursorImpl;
import org.neo4j.driver.internal.cursor.DisposableAsyncStatementResultCursor;
import org.neo4j.driver.internal.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.cursor.RxStatementResultCursorImpl;
import org.neo4j.driver.internal.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;

public class StatementResultCursorFactoryImpl
implements StatementResultCursorFactory {
    private final RunResponseHandler runHandler;
    private final Connection connection;
    private final PullResponseHandler pullHandler;
    private final PullAllResponseHandler pullAllHandler;
    private final boolean waitForRunResponse;
    private final Message runMessage;

    public StatementResultCursorFactoryImpl(Connection connection, Message runMessage, RunResponseHandler runHandler, PullResponseHandler pullHandler, PullAllResponseHandler pullAllHandler, boolean waitForRunResponse) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(runMessage);
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(pullHandler);
        Objects.requireNonNull(pullAllHandler);
        this.connection = connection;
        this.runMessage = runMessage;
        this.runHandler = runHandler;
        this.pullHandler = pullHandler;
        this.pullAllHandler = pullAllHandler;
        this.waitForRunResponse = waitForRunResponse;
    }

    @Override
    public CompletionStage<AsyncStatementResultCursor> asyncResult() {
        this.connection.write(this.runMessage, this.runHandler);
        this.pullAllHandler.prePopulateRecords();
        if (this.waitForRunResponse) {
            return this.runHandler.runFuture().thenApply(ignore -> new DisposableAsyncStatementResultCursor(new AsyncStatementResultCursorImpl(this.runHandler, this.pullAllHandler)));
        }
        return CompletableFuture.completedFuture(new DisposableAsyncStatementResultCursor(new AsyncStatementResultCursorImpl(this.runHandler, this.pullAllHandler)));
    }

    @Override
    public CompletionStage<RxStatementResultCursor> rxResult() {
        this.connection.writeAndFlush(this.runMessage, this.runHandler);
        return this.runHandler.runFuture().thenApply(this::composeRxCursor);
    }

    private RxStatementResultCursor composeRxCursor(Throwable runError) {
        return new RxStatementResultCursorImpl(runError, this.runHandler, this.pullHandler);
    }
}

