/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.neo4j.driver.internal.Bookmark;

public final class InternalBookmark
implements Bookmark {
    private static final InternalBookmark EMPTY = new InternalBookmark(Collections.emptySet());
    private final Collection<String> values;

    private InternalBookmark(Collection<String> values) {
        Objects.requireNonNull(values);
        if (!(values instanceof Serializable)) {
            throw new IllegalArgumentException("The bookmark value should only be of Java built-in types such as ArrayList, HashSet which are serializable.");
        }
        this.values = values;
    }

    public static InternalBookmark empty() {
        return EMPTY;
    }

    public static InternalBookmark from(Iterable<Bookmark> bookmarks) {
        if (bookmarks == null) {
            return InternalBookmark.empty();
        }
        if (bookmarks instanceof Collection) {
            int size = ((Collection)bookmarks).size();
            if (size == 0) {
                return InternalBookmark.empty();
            }
            if (size == 1) {
                return InternalBookmark.from(bookmarks.iterator().next());
            }
        }
        HashSet<String> newValues = new HashSet<String>();
        for (Bookmark value : bookmarks) {
            if (value == null) continue;
            InternalBookmark.assertInternalBookmark(value);
            newValues.addAll(((InternalBookmark)value).values);
        }
        return new InternalBookmark(newValues);
    }

    private static InternalBookmark from(Bookmark bookmark) {
        if (bookmark == null) {
            return InternalBookmark.empty();
        }
        InternalBookmark.assertInternalBookmark(bookmark);
        return (InternalBookmark)bookmark;
    }

    private static void assertInternalBookmark(Bookmark bookmark) {
        if (!(bookmark instanceof InternalBookmark)) {
            throw new IllegalArgumentException(String.format("Received bookmark '%s' is not generated by driver sessions.", bookmark));
        }
    }

    public static InternalBookmark parse(String value) {
        if (value == null) {
            return InternalBookmark.empty();
        }
        return InternalBookmark.parse(Collections.singletonList(value));
    }

    public static InternalBookmark parse(Collection<String> values) {
        if (values == null) {
            return InternalBookmark.empty();
        }
        return new InternalBookmark(values);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Iterable<String> values() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalBookmark bookmark = (InternalBookmark)o;
        return Objects.equals(this.values, bookmark.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "Bookmark{values=" + this.values + "}";
    }
}

