/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxMapFuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoOperator;

final class MonoMapFuseable<T, R>
extends MonoOperator<T, R>
implements Fuseable {
    final Function<? super T, ? extends R> mapper;

    MonoMapFuseable(Mono<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            this.source.subscribe(new FluxMapFuseable.MapFuseableConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new FluxMapFuseable.MapFuseableSubscriber<T, R>(actual, this.mapper));
    }
}

