/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.AbstractBasicPullResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class SessionPullResponseHandler
extends AbstractBasicPullResponseHandler {
    private final BookmarksHolder bookmarksHolder;

    public SessionPullResponseHandler(Statement statement, RunResponseHandler runResponseHandler, Connection connection, BookmarksHolder bookmarksHolder, MetadataExtractor metadataExtractor) {
        super(statement, runResponseHandler, connection, metadataExtractor);
        this.bookmarksHolder = Objects.requireNonNull(bookmarksHolder);
    }

    @Override
    protected void afterSuccess(Map<String, Value> metadata) {
        this.releaseConnection();
        this.bookmarksHolder.setBookmarks(this.metadataExtractor.extractBookmarks(metadata));
    }

    @Override
    protected void afterFailure(Throwable error) {
        this.releaseConnection();
    }

    private void releaseConnection() {
        this.connection.release();
    }
}

