/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.group.ChannelGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.group.DefaultChannelGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPoolHandler;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;

public class NettyChannelTracker
implements ChannelPoolHandler {
    private final Map<BoltServerAddress, AtomicInteger> addressToInUseChannelCount = new ConcurrentHashMap<BoltServerAddress, AtomicInteger>();
    private final Map<BoltServerAddress, AtomicInteger> addressToIdleChannelCount = new ConcurrentHashMap<BoltServerAddress, AtomicInteger>();
    private final Logger log;
    private final MetricsListener metricsListener;
    private final ChannelFutureListener closeListener = future -> this.channelClosed(future.channel());
    private final ChannelGroup allChannels;

    public NettyChannelTracker(MetricsListener metricsListener, EventExecutor eventExecutor, Logging logging) {
        this(metricsListener, new DefaultChannelGroup("all-connections", eventExecutor), logging);
    }

    public NettyChannelTracker(MetricsListener metricsListener, ChannelGroup channels, Logging logging) {
        this.metricsListener = metricsListener;
        this.log = logging.getLog(this.getClass().getSimpleName());
        this.allChannels = channels;
    }

    @Override
    public void channelReleased(Channel channel) {
        this.log.debug("Channel [%s] released back to the pool", channel.id());
        this.decrementInUse(channel);
        this.incrementIdle(channel);
        channel.closeFuture().addListener(this.closeListener);
    }

    @Override
    public void channelAcquired(Channel channel) {
        this.log.debug("Channel [%s] acquired from the pool. Local address: %s, remote address: %s", channel.id(), channel.localAddress(), channel.remoteAddress());
        this.incrementInUse(channel);
        this.decrementIdle(channel);
        channel.closeFuture().removeListener(this.closeListener);
    }

    @Override
    public void channelCreated(Channel channel) {
        throw new IllegalStateException("Untraceable channel created.");
    }

    public void channelCreated(Channel channel, ListenerEvent creatingEvent) {
        this.log.debug("Channel [%s] created. Local address: %s, remote address: %s", channel.id(), channel.localAddress(), channel.remoteAddress());
        this.incrementInUse(channel);
        this.metricsListener.afterCreated(ChannelAttributes.serverAddress(channel), creatingEvent);
        this.allChannels.add(channel);
    }

    public ListenerEvent channelCreating(BoltServerAddress address) {
        ListenerEvent creatingEvent = this.metricsListener.createListenerEvent();
        this.metricsListener.beforeCreating(address, creatingEvent);
        return creatingEvent;
    }

    public void channelFailedToCreate(BoltServerAddress address) {
        this.metricsListener.afterFailedToCreate(address);
    }

    public void channelClosed(Channel channel) {
        this.decrementIdle(channel);
        this.metricsListener.afterClosed(ChannelAttributes.serverAddress(channel));
    }

    public int inUseChannelCount(BoltServerAddress address) {
        AtomicInteger count = this.addressToInUseChannelCount.get(address);
        return count == null ? 0 : count.get();
    }

    public int idleChannelCount(BoltServerAddress address) {
        AtomicInteger count = this.addressToIdleChannelCount.get(address);
        return count == null ? 0 : count.get();
    }

    public void prepareToCloseChannels() {
        for (Channel channel : this.allChannels) {
            BoltProtocol protocol = BoltProtocol.forChannel(channel);
            try {
                protocol.prepareToCloseChannel(channel);
            }
            catch (Throwable e) {
                this.log.debug("Failed to prepare to close Channel %s due to error %s. It is safe to ignore this error as the channel will be closed despite if it is successfully prepared to close or not.", channel, e.getMessage());
            }
        }
    }

    private void incrementInUse(Channel channel) {
        this.increment(channel, this.addressToInUseChannelCount);
    }

    private void decrementInUse(Channel channel) {
        this.decrement(channel, this.addressToInUseChannelCount);
    }

    private void incrementIdle(Channel channel) {
        this.increment(channel, this.addressToIdleChannelCount);
    }

    private void decrementIdle(Channel channel) {
        this.decrement(channel, this.addressToIdleChannelCount);
    }

    private void increment(Channel channel, Map<BoltServerAddress, AtomicInteger> countMap) {
        BoltServerAddress address = ChannelAttributes.serverAddress(channel);
        AtomicInteger count = countMap.computeIfAbsent(address, k -> new AtomicInteger());
        count.incrementAndGet();
    }

    private void decrement(Channel channel, Map<BoltServerAddress, AtomicInteger> countMap) {
        BoltServerAddress address = ChannelAttributes.serverAddress(channel);
        AtomicInteger count = countMap.get(address);
        if (count == null) {
            throw new IllegalStateException("No count exist for address '" + address + "'");
        }
        count.decrementAndGet();
    }
}

