/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.async.ChannelConnectedListener;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.async.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.HandshakeCompletedListener;
import org.neo4j.driver.internal.async.NettyChannelInitializer;
import org.neo4j.driver.internal.async.inbound.ConnectTimeoutHandler;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.util.Clock;

public class ChannelConnectorImpl
implements ChannelConnector {
    private final String userAgent;
    private final Map<String, Value> authToken;
    private final SecurityPlan securityPlan;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final int connectTimeoutMillis;
    private final Logging logging;
    private final Clock clock;

    public ChannelConnectorImpl(ConnectionSettings connectionSettings, SecurityPlan securityPlan, Logging logging, Clock clock) {
        this(connectionSettings, securityPlan, new ChannelPipelineBuilderImpl(), logging, clock);
    }

    public ChannelConnectorImpl(ConnectionSettings connectionSettings, SecurityPlan securityPlan, ChannelPipelineBuilder pipelineBuilder, Logging logging, Clock clock) {
        this.userAgent = connectionSettings.userAgent();
        this.authToken = ChannelConnectorImpl.tokenAsMap(connectionSettings.authToken());
        this.connectTimeoutMillis = connectionSettings.connectTimeoutMillis();
        this.securityPlan = Objects.requireNonNull(securityPlan);
        this.pipelineBuilder = pipelineBuilder;
        this.logging = Objects.requireNonNull(logging);
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public ChannelFuture connect(BoltServerAddress address, Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.connectTimeoutMillis);
        bootstrap.handler(new NettyChannelInitializer(address, this.securityPlan, this.connectTimeoutMillis, this.clock, this.logging));
        ChannelFuture channelConnected = bootstrap.connect(address.toSocketAddress());
        Channel channel = channelConnected.channel();
        ChannelPromise handshakeCompleted = channel.newPromise();
        ChannelPromise connectionInitialized = channel.newPromise();
        this.installChannelConnectedListeners(address, channelConnected, handshakeCompleted);
        this.installHandshakeCompletedListeners(handshakeCompleted, connectionInitialized);
        return connectionInitialized;
    }

    private void installChannelConnectedListeners(BoltServerAddress address, ChannelFuture channelConnected, ChannelPromise handshakeCompleted) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        channelConnected.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> pipeline.addFirst(new ConnectTimeoutHandler((long)this.connectTimeoutMillis))));
        channelConnected.addListener(new ChannelConnectedListener(address, this.pipelineBuilder, handshakeCompleted, this.logging));
    }

    private void installHandshakeCompletedListeners(ChannelPromise handshakeCompleted, ChannelPromise connectionInitialized) {
        ChannelPipeline pipeline = handshakeCompleted.channel().pipeline();
        handshakeCompleted.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> pipeline.remove(ConnectTimeoutHandler.class)));
        handshakeCompleted.addListener(new HandshakeCompletedListener(this.userAgent, this.authToken, connectionInitialized));
    }

    private static Map<String, Value> tokenAsMap(AuthToken token) {
        if (token instanceof InternalAuthToken) {
            return ((InternalAuthToken)token).toMap();
        }
        throw new ClientException("Unknown authentication token, `" + token + "`. Please use one of the supported tokens from `" + AuthTokens.class.getSimpleName() + "`.");
    }
}

