/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Session;
import org.neo4j.driver.Statement;
import org.neo4j.driver.StatementResult;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.AbstractStatementRunner;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.logging.PrefixedLogger;
import org.neo4j.driver.internal.reactive.cursor.InternalStatementResultCursor;
import org.neo4j.driver.internal.reactive.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.reactive.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;

public class NetworkSession
extends AbstractStatementRunner
implements Session,
AsyncSession {
    private static final String LOG_NAME = "Session";
    private final ConnectionProvider connectionProvider;
    private final AccessMode mode;
    private final String databaseName;
    private final RetryLogic retryLogic;
    protected final Logger logger;
    private final BookmarksHolder bookmarksHolder;
    private volatile CompletionStage<ExplicitTransaction> transactionStage = Futures.completedWithNull();
    private volatile CompletionStage<Connection> connectionStage = Futures.completedWithNull();
    private volatile CompletionStage<? extends FailableCursor> resultCursorStage = Futures.completedWithNull();
    private final AtomicBoolean open = new AtomicBoolean(true);

    public NetworkSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, String databaseName, AccessMode mode, BookmarksHolder bookmarksHolder, Logging logging) {
        this.connectionProvider = connectionProvider;
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logger = new PrefixedLogger("[" + this.hashCode() + "]", logging.getLog(LOG_NAME));
        this.bookmarksHolder = bookmarksHolder;
        this.databaseName = databaseName;
    }

    @Override
    public StatementResult run(Statement statement) {
        return this.run(statement, TransactionConfig.empty());
    }

    @Override
    public StatementResult run(String statement, TransactionConfig config) {
        return this.run(statement, Collections.emptyMap(), config);
    }

    @Override
    public StatementResult run(String statement, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Statement(statement, parameters), config);
    }

    @Override
    public StatementResult run(Statement statement, TransactionConfig config) {
        StatementResultCursor cursor = Futures.blockingGet(this.run(statement, config, false), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in session"));
        Connection connection = Futures.getNow(this.connectionStage);
        return new InternalStatementResult(connection, cursor);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        return this.runAsync(statement, TransactionConfig.empty());
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statement, TransactionConfig config) {
        return this.runAsync(statement, Collections.emptyMap(), config);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statement, Map<String, Object> parameters, TransactionConfig config) {
        return this.runAsync(new Statement(statement, parameters), config);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement, TransactionConfig config) {
        return this.run(statement, config, true);
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the session"));
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        if (this.open.compareAndSet(true, false)) {
            return this.resultCursorStage.thenCompose(cursor -> {
                if (cursor != null) {
                    return cursor.failureAsync();
                }
                return Futures.completedWithNull();
            }).thenCompose(cursorError -> this.closeTransactionAndReleaseConnection().thenApply(txCloseError -> {
                CompletionException combinedError = Futures.combineErrors(cursorError, txCloseError);
                if (combinedError != null) {
                    throw combinedError;
                }
                return null;
            }));
        }
        return Futures.completedWithNull();
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    @Override
    public Transaction beginTransaction(TransactionConfig config) {
        return this.beginTransaction(this.mode, config);
    }

    @Override
    @Deprecated
    public Transaction beginTransaction(String bookmark) {
        this.bookmarksHolder.setBookmarks(Bookmarks.from(bookmark));
        return this.beginTransaction();
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.beginTransactionAsync(TransactionConfig.empty());
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.beginTransactionAsync(this.mode, config);
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.READ, work, config);
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.readTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.READ, work, config);
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.WRITE, work, config);
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.writeTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.WRITE, work, config);
    }

    @Override
    public String lastBookmark() {
        return this.bookmarksHolder.lastBookmark();
    }

    @Override
    public void reset() {
        Futures.blockingGet(this.resetAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while resetting the session"));
    }

    public CompletionStage<Void> resetAsync() {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                tx.markTerminated();
            }
        }).thenCompose(ignore -> this.connectionStage).thenCompose(connection -> {
            if (connection != null) {
                return connection.reset();
            }
            return Futures.completedWithNull();
        });
    }

    CompletionStage<Boolean> currentConnectionIsOpen() {
        return this.connectionStage.handle((connection, error) -> error == null && connection != null && connection.isOpen());
    }

    private <T> T transaction(AccessMode mode, TransactionWork<T> work, TransactionConfig config) {
        return (T)this.retryLogic.retry(() -> {
            Throwable throwable = null;
            try (Transaction tx = this.beginTransaction(mode, config);){
                Object result = work.execute(tx);
                tx.success();
                Object t = result;
                return t;
            }
            catch (Throwable t) {
                try {
                    tx.failure();
                    throw t;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.retryLogic.retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<ExplicitTransaction> txFuture = this.beginTransactionAsync(mode, config);
            txFuture.whenComplete((tx, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    resultFuture.completeExceptionally(error);
                } else {
                    this.executeWork(resultFuture, (ExplicitTransaction)tx, work);
                }
            });
            return resultFuture;
        });
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, ExplicitTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work);
        workFuture.whenComplete((result, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                this.rollbackTxAfterFailedTransactionWork(tx, resultFuture, error);
            } else {
                this.closeTxAfterSucceededTransactionWork(tx, resultFuture, result);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(ExplicitTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        try {
            CompletionStage<T> result = work.execute(tx);
            return result == null ? Futures.completedWithNull() : result;
        }
        catch (Throwable workError) {
            return Futures.failedFuture(workError);
        }
    }

    private <T> void rollbackTxAfterFailedTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, Throwable error) {
        if (tx.isOpen()) {
            tx.rollbackAsync().whenComplete((ignore, rollbackError) -> {
                if (rollbackError != null) {
                    error.addSuppressed((Throwable)rollbackError);
                }
                resultFuture.completeExceptionally(error);
            });
        } else {
            resultFuture.completeExceptionally(error);
        }
    }

    private <T> void closeTxAfterSucceededTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, T result) {
        if (tx.isOpen()) {
            tx.success();
            tx.closeAsync().whenComplete((ignore, completionError) -> {
                Throwable commitError = Futures.completionExceptionCause(completionError);
                if (commitError != null) {
                    resultFuture.completeExceptionally(commitError);
                } else {
                    resultFuture.complete(result);
                }
            });
        } else {
            resultFuture.complete(result);
        }
    }

    public CompletionStage<RxStatementResultCursor> runRx(Statement statement, TransactionConfig config) {
        CompletionStage<RxStatementResultCursor> newResultCursorStage = this.buildResultCursorFactory(statement, config, true).thenCompose(StatementResultCursorFactory::rxResult);
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage;
    }

    private CompletionStage<InternalStatementResultCursor> run(Statement statement, TransactionConfig config, boolean waitForRunResponse) {
        CompletionStage<InternalStatementResultCursor> newResultCursorStage = this.buildResultCursorFactory(statement, config, waitForRunResponse).thenCompose(StatementResultCursorFactory::asyncResult);
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage;
    }

    private CompletionStage<StatementResultCursorFactory> buildResultCursorFactory(Statement statement, TransactionConfig config, boolean waitForRunResponse) {
        this.ensureSessionIsOpen();
        return this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.databaseName, this.mode)).thenCompose(connection -> {
            try {
                StatementResultCursorFactory factory = connection.protocol().runInAutoCommitTransaction((Connection)connection, statement, this.bookmarksHolder, config, waitForRunResponse);
                return CompletableFuture.completedFuture(factory);
            }
            catch (Throwable e) {
                return Futures.failedFuture(e);
            }
        });
    }

    private Transaction beginTransaction(AccessMode mode, TransactionConfig config) {
        return Futures.blockingGet(this.beginTransactionAsync(mode, config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
    }

    private CompletionStage<ExplicitTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config) {
        this.ensureSessionIsOpen();
        CompletionStage<ExplicitTransaction> newTransactionStage = this.ensureNoOpenTxBeforeStartingTx().thenCompose(ignore -> this.acquireConnection(this.databaseName, mode)).thenCompose(connection -> {
            ExplicitTransaction tx = new ExplicitTransaction((Connection)connection, this.bookmarksHolder);
            return tx.beginAsync(this.bookmarksHolder.getBookmarks(), config);
        });
        CompletionStage<ExplicitTransaction> currentTransactionStage = this.transactionStage;
        this.transactionStage = newTransactionStage.exceptionally(error -> null).thenCompose(tx -> {
            if (tx == null) {
                return currentTransactionStage;
            }
            return CompletableFuture.completedFuture(tx);
        });
        return newTransactionStage;
    }

    private CompletionStage<Connection> acquireConnection(String databaseName, AccessMode mode) {
        CompletionStage<Connection> currentConnectionStage = this.connectionStage;
        CompletionStage<Connection> newConnectionStage = this.resultCursorStage.thenCompose(cursor -> {
            if (cursor == null) {
                return Futures.completedWithNull();
            }
            return cursor.failureAsync();
        }).thenCompose(error -> {
            if (error == null) {
                return currentConnectionStage.exceptionally(ignore -> null);
            }
            throw new CompletionException((Throwable)error);
        }).thenCompose(existingConnection -> {
            if (existingConnection != null && existingConnection.isOpen()) {
                throw new IllegalStateException("Existing open connection detected");
            }
            return this.connectionProvider.acquireConnection(databaseName, mode);
        });
        this.connectionStage = newConnectionStage.exceptionally(error -> null);
        return newConnectionStage;
    }

    private CompletionStage<Throwable> closeTransactionAndReleaseConnection() {
        return this.existingTransactionOrNull().thenCompose(tx -> {
            if (tx != null) {
                return tx.closeAsync().thenApply(ignore -> null).exceptionally(error -> error);
            }
            return Futures.completedWithNull();
        }).thenCompose(txCloseError -> this.releaseConnection().thenApply(ignore -> txCloseError));
    }

    public CompletionStage<Void> releaseConnection() {
        return this.connectionStage.thenCompose(connection -> {
            if (connection != null) {
                return connection.release();
            }
            return Futures.completedWithNull();
        });
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        Connection connection = null;
        try {
            connection = Futures.getNow(this.connectionStage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (connection != null) {
            connection.terminateAndRelease(reason);
        }
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeRunningQuery() {
        return this.ensureNoOpenTx("Statements cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeStartingTx() {
        return this.ensureNoOpenTx("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTx(String errorMessage) {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                throw new ClientException(errorMessage);
            }
        });
    }

    private CompletionStage<ExplicitTransaction> existingTransactionOrNull() {
        return this.transactionStage.exceptionally(error -> null).thenApply(tx -> tx != null && tx.isOpen() ? tx : null);
    }

    private void ensureSessionIsOpen() {
        if (!this.open.get()) {
            throw new ClientException("No more interaction with this session are allowed as the current session is already closed. ");
        }
    }
}

