/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.messaging.request.TransactionStartingMessage;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.TransactionConfig;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public class RunWithMetadataMessage
extends TransactionStartingMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final Map<String, Value> parameters;

    public static RunWithMetadataMessage autoCommitTxRunMessage(Statement statement, TransactionConfig config, AccessMode mode, Bookmarks bookmark) {
        return RunWithMetadataMessage.autoCommitTxRunMessage(statement.text(), statement.parameters().asMap(Values.ofValue()), config.timeout(), config.metadata(), mode, bookmark);
    }

    public static RunWithMetadataMessage autoCommitTxRunMessage(String statement, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, AccessMode mode, Bookmarks bookmark) {
        Map<String, Value> metadata = RunWithMetadataMessage.buildMetadata(bookmark, txTimeout, txMetadata, mode);
        return new RunWithMetadataMessage(statement, parameters, metadata);
    }

    public static RunWithMetadataMessage explicitTxRunMessage(Statement statement) {
        return new RunWithMetadataMessage(statement.text(), statement.parameters().asMap(Values.ofValue()), Collections.emptyMap());
    }

    public RunWithMetadataMessage(String statement, Map<String, Value> parameters, Map<String, Value> metadata) {
        super(metadata);
        this.statement = statement;
        this.parameters = parameters;
    }

    public String statement() {
        return this.statement;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunWithMetadataMessage that = (RunWithMetadataMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.parameters, this.metadata);
    }

    public String toString() {
        return "RUN \"" + this.statement + "\" " + this.parameters + " " + this.metadata;
    }
}

