/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.messaging.ValueUnpacker;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackStream;
import org.neo4j.driver.internal.packstream.PackType;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;

public class ValueUnpackerV1
implements ValueUnpacker {
    protected final PackStream.Unpacker unpacker;

    public ValueUnpackerV1(PackInput input) {
        this.unpacker = new PackStream.Unpacker(input);
    }

    @Override
    public long unpackStructHeader() throws IOException {
        return this.unpacker.unpackStructHeader();
    }

    @Override
    public int unpackStructSignature() throws IOException {
        return this.unpacker.unpackStructSignature();
    }

    @Override
    public Map<String, Value> unpackMap() throws IOException {
        int size = (int)this.unpacker.unpackMapHeader();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> map = Iterables.newHashMapWithSize(size);
        for (int i = 0; i < size; ++i) {
            String key = this.unpacker.unpackString();
            map.put(key, this.unpack());
        }
        return map;
    }

    @Override
    public Value[] unpackArray() throws IOException {
        int size = (int)this.unpacker.unpackListHeader();
        Value[] values = new Value[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.unpack();
        }
        return values;
    }

    private Value unpack() throws IOException {
        PackType type = this.unpacker.peekNextType();
        switch (type) {
            case NULL: {
                return Values.value(this.unpacker.unpackNull());
            }
            case BOOLEAN: {
                return Values.value(this.unpacker.unpackBoolean());
            }
            case INTEGER: {
                return Values.value(this.unpacker.unpackLong());
            }
            case FLOAT: {
                return Values.value(this.unpacker.unpackDouble());
            }
            case BYTES: {
                return Values.value(this.unpacker.unpackBytes());
            }
            case STRING: {
                return Values.value(this.unpacker.unpackString());
            }
            case MAP: {
                return new MapValue(this.unpackMap());
            }
            case LIST: {
                int size = (int)this.unpacker.unpackListHeader();
                Value[] vals = new Value[size];
                for (int j = 0; j < size; ++j) {
                    vals[j] = this.unpack();
                }
                return new ListValue(vals);
            }
            case STRUCT: {
                long size = this.unpacker.unpackStructHeader();
                byte structType = this.unpacker.unpackStructSignature();
                return this.unpackStruct(size, structType);
            }
        }
        throw new IOException("Unknown value type: " + (Object)((Object)type));
    }

    protected Value unpackStruct(long size, byte type) throws IOException {
        switch (type) {
            case 78: {
                this.ensureCorrectStructSize(TypeConstructor.NODE, 3, size);
                InternalNode adapted = this.unpackNode();
                return new NodeValue(adapted);
            }
            case 82: {
                this.ensureCorrectStructSize(TypeConstructor.RELATIONSHIP, 5, size);
                return this.unpackRelationship();
            }
            case 80: {
                this.ensureCorrectStructSize(TypeConstructor.PATH, 3, size);
                return this.unpackPath();
            }
        }
        throw new IOException("Unknown struct type: " + type);
    }

    private Value unpackRelationship() throws IOException {
        long urn = this.unpacker.unpackLong();
        long startUrn = this.unpacker.unpackLong();
        long endUrn = this.unpacker.unpackLong();
        String relType = this.unpacker.unpackString();
        Map<String, Value> props = this.unpackMap();
        InternalRelationship adapted = new InternalRelationship(urn, startUrn, endUrn, relType, props);
        return new RelationshipValue(adapted);
    }

    private InternalNode unpackNode() throws IOException {
        long urn = this.unpacker.unpackLong();
        int numLabels = (int)this.unpacker.unpackListHeader();
        ArrayList<String> labels = new ArrayList<String>(numLabels);
        for (int i = 0; i < numLabels; ++i) {
            labels.add(this.unpacker.unpackString());
        }
        int numProps = (int)this.unpacker.unpackMapHeader();
        HashMap<String, Value> props = Iterables.newHashMapWithSize(numProps);
        for (int j = 0; j < numProps; ++j) {
            String key = this.unpacker.unpackString();
            props.put(key, this.unpack());
        }
        return new InternalNode(urn, labels, props);
    }

    private Value unpackPath() throws IOException {
        Node prevNode;
        Node[] uniqNodes = new Node[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqNodes.length; ++i) {
            this.ensureCorrectStructSize(TypeConstructor.NODE, 3, this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("NODE", (byte)78, this.unpacker.unpackStructSignature());
            uniqNodes[i] = this.unpackNode();
        }
        InternalRelationship[] uniqRels = new InternalRelationship[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqRels.length; ++i) {
            this.ensureCorrectStructSize(TypeConstructor.RELATIONSHIP, 3, this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("UNBOUND_RELATIONSHIP", (byte)114, this.unpacker.unpackStructSignature());
            long id = this.unpacker.unpackLong();
            String relType = this.unpacker.unpackString();
            Map<String, Value> props = this.unpackMap();
            uniqRels[i] = new InternalRelationship(id, -1L, -1L, relType, props);
        }
        int length = (int)this.unpacker.unpackListHeader();
        Path.Segment[] segments = new Path.Segment[length / 2];
        Node[] nodes = new Node[segments.length + 1];
        Relationship[] rels = new Relationship[segments.length];
        nodes[0] = prevNode = uniqNodes[0];
        for (int i = 0; i < segments.length; ++i) {
            InternalRelationship rel;
            int relIdx = (int)this.unpacker.unpackLong();
            Node nextNode = uniqNodes[(int)this.unpacker.unpackLong()];
            if (relIdx < 0) {
                rel = uniqRels[-relIdx - 1];
                rel.setStartAndEnd(nextNode.id(), prevNode.id());
            } else {
                rel = uniqRels[relIdx - 1];
                rel.setStartAndEnd(prevNode.id(), nextNode.id());
            }
            nodes[i + 1] = nextNode;
            rels[i] = rel;
            segments[i] = new InternalPath.SelfContainedSegment(prevNode, rel, nextNode);
            prevNode = nextNode;
        }
        return new PathValue(new InternalPath(Arrays.asList(segments), Arrays.asList(nodes), Arrays.asList(rels)));
    }

    protected final void ensureCorrectStructSize(TypeConstructor typeConstructor, int expected, long actual) {
        if ((long)expected != actual) {
            String structName = typeConstructor.toString();
            throw new ClientException(String.format("Invalid message received, serialized %s structures should have %d fields, received %s structure has %d fields.", structName, expected, structName, actual));
        }
    }

    private void ensureCorrectStructSignature(String structName, byte expected, byte actual) {
        if (expected != actual) {
            throw new ClientException(String.format("Invalid message received, expected a `%s`, signature 0x%s. Received signature was 0x%s.", structName, Integer.toHexString(expected), Integer.toHexString(actual)));
        }
    }
}

