/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logging;

public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final BoltServerAddress address;
    private final SecurityPlan securityPlan;
    private final int connectTimeoutMillis;
    private final Clock clock;
    private final Logging logging;

    public NettyChannelInitializer(BoltServerAddress address, SecurityPlan securityPlan, int connectTimeoutMillis, Clock clock, Logging logging) {
        this.address = address;
        this.securityPlan = securityPlan;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.clock = clock;
        this.logging = logging;
    }

    @Override
    protected void initChannel(Channel channel) {
        if (this.securityPlan.requiresEncryption()) {
            SslHandler sslHandler = this.createSslHandler();
            channel.pipeline().addFirst(sslHandler);
        }
        this.updateChannelAttributes(channel);
    }

    private SslHandler createSslHandler() {
        SSLEngine sslEngine = this.createSslEngine();
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(this.connectTimeoutMillis);
        return sslHandler;
    }

    private SSLEngine createSslEngine() {
        SSLContext sslContext = this.securityPlan.sslContext();
        SSLEngine sslEngine = sslContext.createSSLEngine(this.address.host(), this.address.port());
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }

    private void updateChannelAttributes(Channel channel) {
        ChannelAttributes.setServerAddress(channel, this.address);
        ChannelAttributes.setCreationTimestamp(channel, this.clock.millis());
        ChannelAttributes.setMessageDispatcher(channel, new InboundMessageDispatcher(channel, this.logging));
    }
}

