/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.v1.Value;

public class CommitTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> commitFuture;
    private final ExplicitTransaction tx;

    public CommitTxResponseHandler(CompletableFuture<Void> commitFuture, ExplicitTransaction tx) {
        this.commitFuture = Objects.requireNonNull(commitFuture);
        this.tx = Objects.requireNonNull(tx);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        if (bookmarkValue != null && this.tx != null) {
            this.tx.setBookmark(Bookmark.from(bookmarkValue.asString()));
        }
        this.commitFuture.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.commitFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction commit is not expected to receive records: " + Arrays.toString(fields));
    }
}

