/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.InternalStatementResultCursor;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.async.QueryRunner;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.TypeSystem;

public class ExplicitTransaction
implements Transaction {
    private static final String BEGIN_QUERY = "BEGIN";
    private static final String COMMIT_QUERY = "COMMIT";
    private static final String ROLLBACK_QUERY = "ROLLBACK";
    private final Connection connection;
    private final NetworkSession session;
    private final ResultCursorsHolder resultCursors;
    private volatile Bookmark bookmark = Bookmark.empty();
    private volatile State state = State.ACTIVE;

    public ExplicitTransaction(Connection connection, NetworkSession session) {
        this.connection = connection;
        this.session = session;
        this.resultCursors = new ResultCursorsHolder();
    }

    public CompletionStage<ExplicitTransaction> beginAsync(Bookmark initialBookmark) {
        if (initialBookmark.isEmpty()) {
            this.connection.run(BEGIN_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE, NoOpResponseHandler.INSTANCE);
            return CompletableFuture.completedFuture(this);
        }
        CompletableFuture beginFuture = new CompletableFuture();
        this.connection.runAndFlush(BEGIN_QUERY, initialBookmark.asBeginTransactionParameters(), NoOpResponseHandler.INSTANCE, new BeginTxResponseHandler<ExplicitTransaction>(beginFuture, this));
        return beginFuture.handle((tx, beginError) -> {
            if (beginError != null) {
                this.connection.release();
                throw Futures.asCompletionException(beginError);
            }
            return tx;
        });
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the transaction"));
    }

    CompletionStage<Void> closeAsync() {
        if (this.state == State.MARKED_SUCCESS) {
            return this.commitAsync();
        }
        if (this.state != State.COMMITTED && this.state != State.ROLLED_BACK) {
            return this.rollbackAsync();
        }
        return Futures.completedWithNull();
    }

    @Override
    public CompletionStage<Void> commitAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.completedWithNull();
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been rolled back"));
        }
        if (this.state == State.TERMINATED) {
            this.transactionClosed(State.ROLLED_BACK);
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been terminated"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doCommitAsync().handle(this.handleCommitOrRollback((Throwable)error))).whenComplete((ignore, error) -> this.transactionClosed(State.COMMITTED));
    }

    @Override
    public CompletionStage<Void> rollbackAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been committed"));
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.completedWithNull();
        }
        if (this.state == State.TERMINATED) {
            this.transactionClosed(State.ROLLED_BACK);
            return Futures.completedWithNull();
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doRollbackAsync().handle(this.handleCommitOrRollback((Throwable)error))).whenComplete((ignore, error) -> this.transactionClosed(State.ROLLED_BACK));
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementText, Value parameters) {
        return this.runAsync(new Statement(statementText, parameters));
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate) {
        return this.runAsync(statementTemplate, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.run(statementText, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Map<String, Object> statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters);
        return this.runAsync(statementTemplate, params);
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.run(statementTemplate, params);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Record statementParameters) {
        Value params = statementParameters == null ? Values.EmptyMap : Values.value(statementParameters.asMap());
        return this.runAsync(statementTemplate, params);
    }

    @Override
    public StatementResult run(Statement statement) {
        StatementResultCursor cursor = Futures.blockingGet(this.run(statement, false), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in transaction"));
        return new InternalStatementResult(this.connection, cursor);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        return this.run(statement, true);
    }

    private CompletionStage<InternalStatementResultCursor> run(Statement statement, boolean waitForRunResponse) {
        this.ensureCanRunQueries();
        CompletionStage<InternalStatementResultCursor> cursorStage = QueryRunner.runInTransaction(this.connection, statement, this, waitForRunResponse);
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    private void ensureCanRunQueries() {
        if (this.state == State.COMMITTED) {
            throw new ClientException("Cannot run more statements in this transaction, it has been committed");
        }
        if (this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more statements in this transaction, it has been rolled back");
        }
        if (this.state == State.MARKED_FAILED) {
            throw new ClientException("Cannot run more statements in this transaction, because previous statements in the transaction has failed and the transaction has been rolled back. Please start a new transaction to run another statement.");
        }
        if (this.state == State.TERMINATED) {
            throw new ClientException("Cannot run more statements in this transaction, it has been terminated");
        }
    }

    @Override
    public boolean isOpen() {
        return this.state != State.COMMITTED && this.state != State.ROLLED_BACK;
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    public void markTerminated() {
        this.state = State.TERMINATED;
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        if (bookmark != null && !bookmark.isEmpty()) {
            this.bookmark = bookmark;
        }
    }

    private CompletionStage<Void> doCommitAsync() {
        CompletableFuture<Void> commitFuture = new CompletableFuture<Void>();
        CommitTxResponseHandler pullAllHandler = new CommitTxResponseHandler(commitFuture, this);
        this.connection.runAndFlush(COMMIT_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE, pullAllHandler);
        return commitFuture;
    }

    private CompletionStage<Void> doRollbackAsync() {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        RollbackTxResponseHandler pullAllHandler = new RollbackTxResponseHandler(rollbackFuture);
        this.connection.runAndFlush(ROLLBACK_QUERY, Collections.emptyMap(), NoOpResponseHandler.INSTANCE, pullAllHandler);
        return rollbackFuture;
    }

    private BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError);
            if (combinedError != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private void transactionClosed(State newState) {
        this.state = newState;
        this.connection.release();
        this.session.setBookmark(this.bookmark);
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        this.connection.terminateAndRelease(reason);
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }
}

