/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.neo4j.driver.internal.async.EventLoopGroupFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public final class Futures {
    private Futures() {
    }

    public static <T> CompletionStage<T> asCompletionStage(Future<T> future) {
        CompletableFuture result = new CompletableFuture();
        if (future.isCancelled()) {
            result.cancel(true);
        } else if (future.isSuccess()) {
            result.complete(future.getNow());
        } else if (future.cause() != null) {
            result.completeExceptionally(future.cause());
        } else {
            future.addListener(ignore -> {
                if (future.isCancelled()) {
                    result.cancel(true);
                } else if (future.isSuccess()) {
                    result.complete(future.getNow());
                } else {
                    result.completeExceptionally(future.cause());
                }
            });
        }
        return result;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(error);
        return result;
    }

    public static <V> V blockingGet(CompletionStage<V> stage) {
        EventLoopGroupFactory.assertNotInEventLoopThread();
        CompletableFuture<V> future = stage.toCompletableFuture();
        boolean interrupted = false;
        while (true) {
            try {
                Object v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                PlatformDependent.throwException(e.getCause());
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static Throwable completionErrorCause(Throwable error) {
        if (error instanceof CompletionException) {
            return error.getCause();
        }
        return error;
    }
}

